/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.ecologie;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchAdministrativeUnit;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;
import org.openstreetmap.josm.tools.Pair;

public class ForetsPubliquesHandler
extends DataGouvDataSetHandler {
    private static final String PATTERN = "for_publ_v20.._reg(..)";

    public ForetsPubliquesHandler() {
        this.setName("For\u00eats publiques");
    }

    public boolean acceptsFilename(String filename) {
        boolean result;
        boolean bl = result = this.acceptsZipFilename(filename, new String[]{PATTERN}) || this.acceptsShpFilename(filename, new String[]{PATTERN});
        if (result) {
            this.setNationalPortalPath(this.findPortalSuffix(filename));
        }
        return result;
    }

    public boolean acceptsUrl(String url) {
        boolean result = super.acceptsUrl(url);
        if (result) {
            this.setNationalPortalPath(this.findPortalSuffix(url));
        }
        return result;
    }

    private final String findPortalSuffix(CharSequence filename) {
        Matcher m = Pattern.compile(".*for_publ_v20.._reg(..)\\....").matcher(filename);
        if (m.matches()) {
            String regionCode = m.group(1);
            if (regionCode.equals("42")) {
                return "For\u00eats-publiques-d\u2019Alsace-30378695";
            }
            if (regionCode.equals("72")) {
                return "For\u00eats-publiques-d'Aquitaine-30378994";
            }
            if (regionCode.equals("83")) {
                return "For\u00eats-publiques-d'Auvergne-30379302";
            }
            if (regionCode.equals("26")) {
                return "For\u00eats-publiques-de-Bourgogne-30379206";
            }
            if (regionCode.equals("53")) {
                return "For\u00eats-publiques-de-Bretagne-30378874";
            }
            if (regionCode.equals("24")) {
                return "For\u00eats-publiques-du-Centre-30379134";
            }
            if (regionCode.equals("21")) {
                return "For\u00eats-publiques-de-Champagne-Ardenne-30378853";
            }
            if (regionCode.equals("94")) {
                return "For\u00eats-publiques-de-Corse-30379118";
            }
            if (regionCode.equals("43")) {
                return "For\u00eats-publiques-de-Franche-Comt\u00e9-30378652";
            }
            if (regionCode.equals("11")) {
                return "For\u00eats-publiques-d\u2019\u00cele-de-France-30378829";
            }
            if (regionCode.equals("91")) {
                return "For\u00eats-publiques-de-Languedoc-Roussillon-30379312";
            }
            if (regionCode.equals("74")) {
                return "For\u00eats-publiques-du-Limousin-30378844";
            }
            if (regionCode.equals("41")) {
                return "For\u00eats-publiques-de-Lorraine-30378675";
            }
            if (regionCode.equals("73")) {
                return "For\u00eats-publiques-de-Midi-Pyr\u00e9n\u00e9es-30378665";
            }
            if (regionCode.equals("31")) {
                return "For\u00eats-publiques-du-Nord-Pas-de-Calais-30379095";
            }
            if (regionCode.equals("25")) {
                return "For\u00eats-publiques-de-Basse-Normandie-30378962";
            }
            if (regionCode.equals("23")) {
                return "For\u00eats-publiques-de-Haute-Normandie-30379164";
            }
            if (regionCode.equals("52")) {
                return "For\u00eats-publiques-des-Pays-de-la-Loire-30378999";
            }
            if (regionCode.equals("22")) {
                return "For\u00eats-publiques-de-Picardie-30379389";
            }
            if (regionCode.equals("54")) {
                return "For\u00eats-publiques-de-Poitou-Charente-30378900";
            }
            if (regionCode.equals("93")) {
                return "For\u00eats-publiques-de-PACA-30379322";
            }
            if (regionCode.equals("82")) {
                return "For\u00eats-publiques-de-Rh\u00f4ne-Alpes-30378732";
            }
            System.err.println("Unknown French region code: " + regionCode);
        }
        return null;
    }

    public void updateDataSet(DataSet ds) {
        for (OsmPrimitive p : ds.allPrimitives()) {
            if (!p.hasKey("IIDTN_FRT")) continue;
            p.put("landuse", "forest");
            this.replace((IPrimitive)p, "LLIB_FRT", "name");
        }
    }

    public List<Pair<String, URL>> getDataURLs() {
        ArrayList<Pair<String, URL>> result = new ArrayList<Pair<String, URL>>();
        try {
            for (FrenchAdministrativeUnit.FrenchRegion region : FrenchAdministrativeUnit.allRegions) {
                if (region.getCode().startsWith("0")) continue;
                result.add(this.getForetURL(region.getCode(), region.getName()));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }

    private Pair<String, URL> getForetURL(String code, String name) throws MalformedURLException {
        return new Pair((Object)name, (Object)new URL("http://www.data.gouv.fr/var/download/for_publ_v2011_reg" + code + ".zip"));
    }
}

