/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.administration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.text.WordUtils;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;
import org.openstreetmap.josm.tools.Pair;

public class GeoFlaHandler
extends DataGouvDataSetHandler {
    public GeoFlaHandler() {
        this.setName("GEOFLA\u00ae");
    }

    @Override
    public URL getLocalPortalURL() {
        try {
            return new URL("http://professionnels.ign.fr/ficheProduitCMS.do?idDoc=6185461");
        }
        catch (MalformedURLException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }

    public String getLocalPortalIconName() {
        return "data.fr.ign_24.png";
    }

    public boolean acceptsFilename(String filename) {
        return this.isDepartementFile(filename) || this.isCommuneFile(filename) || this.isCantonFile(filename) || this.isArrondissementFile(filename);
    }

    protected boolean isDepartementFile(String filename) {
        return this.acceptsShpMifFilename(filename, new String[]{"DEPARTEMENT"}) || this.acceptsShpMifFilename(filename, new String[]{"LIMITE_DEPARTEMENT"});
    }

    protected boolean isCommuneFile(String filename) {
        return this.acceptsShpFilename(filename, new String[]{"COMMUNE"}) || this.acceptsShpFilename(filename, new String[]{"LIMITE_COMMUNE"});
    }

    protected boolean isCantonFile(String filename) {
        return this.acceptsShpFilename(filename, new String[]{"CANTON"}) || this.acceptsShpFilename(filename, new String[]{"LIMITE_CANTON"});
    }

    protected boolean isArrondissementFile(String filename) {
        return this.acceptsShpFilename(filename, new String[]{"ARRONDISSEMENT"}) || this.acceptsShpFilename(filename, new String[]{"LIMITE_ARRONDISSEMENT"});
    }

    public boolean preferMultipolygonToSimpleWay() {
        return true;
    }

    public void updateDataSet(DataSet ds) {
        String filename = this.getAssociatedFile().getName();
        if (this.isDepartementFile(filename)) {
            this.setNationalPortalPath("GEOFLA\u00ae-D\u00e9partements-30383060");
        } else if (this.isCommuneFile(filename)) {
            this.setNationalPortalPath("GEOFLA\u00ae-Communes-30383083");
        }
        for (OsmPrimitive p : ds.allPrimitives()) {
            LatLon llChefLieu;
            LatLon llCentroid;
            if (!GeoFlaHandler.hasKeyIgnoreCase(p, "Id_geofla", "Id_G\u00e9oFLA")) continue;
            String deptName = WordUtils.capitalizeFully((String)GeoFlaHandler.getAndRemoveIgnoreCase(p, "Nom_dept", "Nom_D\u00e9partement"));
            if ("Reunion".equals(deptName)) {
                deptName = "La R\u00e9union";
            }
            if (this.isDepartementFile(filename)) {
                p.put("name", deptName);
            } else if (this.isCommuneFile(filename)) {
                p.put("name", WordUtils.capitalizeFully((String)GeoFlaHandler.getAndRemoveIgnoreCase(p, "NOM_COMM")));
                this.replace((IPrimitive)p, "INSEE_COM", "ref:INSEE");
            }
            p.put("boundary", "administrative");
            String nature = GeoFlaHandler.getIgnoreCase(p, "Nature");
            if ("Fronti\u00e8re internationale".equalsIgnoreCase(nature) || "Limite c\u00f4ti\u00e8re".equalsIgnoreCase(nature)) {
                p.put("admin_level", "2");
            } else if ("Limite de r\u00e9gion".equalsIgnoreCase(nature)) {
                p.put("admin_level", "4");
            } else if (this.isDepartementFile(filename) || "Limite de d\u00e9partement".equalsIgnoreCase(nature)) {
                p.put("admin_level", "6");
            } else if (this.isArrondissementFile(filename) || "Limite d'arrondissement".equalsIgnoreCase(nature)) {
                p.put("admin_level", "7");
            } else if (this.isCommuneFile(filename)) {
                p.put("admin_level", "8");
            }
            if (p instanceof Relation) {
                p.put("type", "boundary");
            }
            if ((llCentroid = GeoFlaHandler.getLatLon(p, deptName, "centroid", "Centro\u00efde")) != null) {
                Node centroid = new Node(llCentroid);
                ds.addPrimitive((OsmPrimitive)centroid);
                if (p instanceof Relation) {
                    ((Relation)p).addMember(new RelationMember("centroid", (OsmPrimitive)centroid));
                }
            }
            if ((llChefLieu = GeoFlaHandler.getLatLon(p, deptName, "chf_lieu", "Chef_Lieu")) == null) continue;
            Node chefLieu = new Node(llChefLieu);
            ds.addPrimitive((OsmPrimitive)chefLieu);
            String name = WordUtils.capitalizeFully((String)GeoFlaHandler.getAndRemoveIgnoreCase(p, "Nom_chf", "Nom_Chef_lieu"));
            if (this.isArrondissementFile(filename)) {
                p.put("name", name);
            }
            chefLieu.put("name", name);
            if (!(p instanceof Relation)) continue;
            ((Relation)p).addMember(new RelationMember("admin_centre", (OsmPrimitive)chefLieu));
        }
    }

    protected static boolean hasKeyIgnoreCase(OsmPrimitive p, String ... strings) {
        return GeoFlaHandler.getIgnoreCase(p, strings) != null;
    }

    protected static String getIgnoreCase(OsmPrimitive p, String ... strings) {
        String result = null;
        for (String s : strings) {
            if (result == null) {
                result = p.get(s);
            }
            if (result == null) {
                result = p.get(s.toUpperCase());
            }
            if (result != null) continue;
            result = p.get(s.toLowerCase());
        }
        return result;
    }

    protected static void removeIgnoreCase(OsmPrimitive p, String ... strings) {
        for (String s : strings) {
            p.remove(s);
            p.remove(s.toUpperCase());
            p.remove(s.toLowerCase());
        }
    }

    protected static String getAndRemoveIgnoreCase(OsmPrimitive p, String ... strings) {
        String result = GeoFlaHandler.getIgnoreCase(p, strings);
        GeoFlaHandler.removeIgnoreCase(p, strings);
        return result;
    }

    protected static LatLon getLatLon(OsmPrimitive p, String dptName, String shortAttribute, String longAttribute) {
        String x = GeoFlaHandler.getAndRemoveIgnoreCase(p, "X_" + shortAttribute, "Abscisse_" + longAttribute);
        String y = GeoFlaHandler.getAndRemoveIgnoreCase(p, "Y_" + shortAttribute, "Ordonn\u00e9e_" + longAttribute);
        if (x != null && y != null) {
            try {
                String dptCode = GeoFlaHandler.getIgnoreCase(p, "Code_dept", "Code_D\u00e9partement");
                if (dptCode != null && dptCode.equals("97") && dptName != null) {
                    if (dptName.equals("Guadeloupe")) {
                        dptCode = "971";
                    } else if (dptName.equals("Martinique")) {
                        dptCode = "972";
                    } else if (dptName.equals("Guyane")) {
                        dptCode = "973";
                    } else if (dptName.equals("La R\u00e9union")) {
                        dptCode = "974";
                    } else if (dptName.equals("Mayotte")) {
                        dptCode = "976";
                    } else {
                        System.err.println("Unknown French department: " + dptName);
                    }
                }
                return GeoFlaHandler.getLatLonByDptCode((EastNorth)new EastNorth(Double.parseDouble(x) * 100.0, Double.parseDouble(y) * 100.0), (String)dptCode, (boolean)false);
            }
            catch (NumberFormatException e) {
                System.err.println(e.getMessage());
            }
        }
        return null;
    }

    private Pair<String, URL> getGeoflaURL(String name, String urlSuffix) throws MalformedURLException {
        return new Pair((Object)name, (Object)new URL("http://professionnels.ign.fr/DISPLAY/000/" + urlSuffix));
    }

    public List<Pair<String, URL>> getDataURLs() {
        ArrayList<Pair<String, URL>> result = new ArrayList<Pair<String, URL>>();
        try {
            result.add(this.getGeoflaURL("D\u00e9partements France m\u00e9tropolitaine et Corse", "528/175/5281750/GEOFLADept_FR_Corse_AV_L93.zip"));
            result.add(this.getGeoflaURL("D\u00e9partements France enti\u00e8re", "528/175/5281754/FR_DOM_Mayotte_shp_WGS84.zip"));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

