/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.operation.matrix;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.geotools.resources.i18n.Errors;

public class XAffineTransform
extends AffineTransform {
    private static final long serialVersionUID = 5215291166450556451L;

    public XAffineTransform(AffineTransform tr) {
        super(tr);
    }

    protected void checkPermission() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Errors.format(188));
    }

    @Override
    public void translate(double tx, double ty) {
        this.checkPermission();
        super.translate(tx, ty);
    }

    @Override
    public void rotate(double theta) {
        this.checkPermission();
        super.rotate(theta);
    }

    @Override
    public void rotate(double theta, double x, double y) {
        this.checkPermission();
        super.rotate(theta, x, y);
    }

    @Override
    public void scale(double sx, double sy) {
        this.checkPermission();
        super.scale(sx, sy);
    }

    @Override
    public void shear(double shx, double shy) {
        this.checkPermission();
        super.shear(shx, shy);
    }

    @Override
    public void setToIdentity() {
        this.checkPermission();
        super.setToIdentity();
    }

    @Override
    public void setToTranslation(double tx, double ty) {
        this.checkPermission();
        super.setToTranslation(tx, ty);
    }

    @Override
    public void setToRotation(double theta) {
        this.checkPermission();
        super.setToRotation(theta);
    }

    @Override
    public void setToRotation(double theta, double x, double y) {
        this.checkPermission();
        super.setToRotation(theta, x, y);
    }

    @Override
    public void setToScale(double sx, double sy) {
        this.checkPermission();
        super.setToScale(sx, sy);
    }

    @Override
    public void setToShear(double shx, double shy) {
        this.checkPermission();
        super.setToShear(shx, shy);
    }

    @Override
    public void setTransform(AffineTransform Tx) {
        this.checkPermission();
        super.setTransform(Tx);
    }

    @Override
    public void setTransform(double m00, double m10, double m01, double m11, double m02, double m12) {
        this.checkPermission();
        super.setTransform(m00, m10, m01, m11, m02, m12);
    }

    @Override
    public void concatenate(AffineTransform Tx) {
        this.checkPermission();
        super.concatenate(Tx);
    }

    @Override
    public void preConcatenate(AffineTransform Tx) {
        this.checkPermission();
        super.preConcatenate(Tx);
    }

    public boolean isIdentity(double tolerance) {
        return XAffineTransform.isIdentity(this, tolerance);
    }

    public static boolean isIdentity(AffineTransform tr, double tolerance) {
        if (tr.isIdentity()) {
            return true;
        }
        tolerance = Math.abs(tolerance);
        return Math.abs(tr.getScaleX() - 1.0) <= tolerance && Math.abs(tr.getScaleY() - 1.0) <= tolerance && Math.abs(tr.getShearX()) <= tolerance && Math.abs(tr.getShearY()) <= tolerance && Math.abs(tr.getTranslateX()) <= tolerance && Math.abs(tr.getTranslateY()) <= tolerance;
    }

    public static Shape transform(AffineTransform transform, Shape shape, boolean overwrite) {
        int type = transform.getType();
        if (type == 0) {
            return shape;
        }
        if ((type & 0x30) == 0) {
            if (shape instanceof Rectangle2D) {
                Rectangle2D rect = (Rectangle2D)shape;
                return XAffineTransform.transform(transform, rect, overwrite ? rect : null);
            }
            if ((type & 0) == 0 && shape instanceof RectangularShape) {
                RectangularShape rect = (RectangularShape)shape;
                if (!overwrite) {
                    rect = (RectangularShape)rect.clone();
                }
                Rectangle2D frame = rect.getFrame();
                rect.setFrame(XAffineTransform.transform(transform, frame, frame));
                return rect;
            }
        }
        if (shape instanceof GeneralPath) {
            GeneralPath path = (GeneralPath)shape;
            if (overwrite) {
                path.transform(transform);
            } else {
                shape = path.createTransformedShape(transform);
            }
        } else if (shape instanceof Area) {
            Area area = (Area)shape;
            if (overwrite) {
                area.transform(transform);
            } else {
                shape = area.createTransformedArea(transform);
            }
        } else {
            GeneralPath path = new GeneralPath(shape);
            path.transform(transform);
            shape = path;
        }
        return shape;
    }

    public static Rectangle2D transform(AffineTransform transform, Rectangle2D bounds, Rectangle2D dest) {
        double xmin = Double.POSITIVE_INFINITY;
        double ymin = Double.POSITIVE_INFINITY;
        double xmax = Double.NEGATIVE_INFINITY;
        double ymax = Double.NEGATIVE_INFINITY;
        Point2D.Double point = new Point2D.Double();
        for (int i = 0; i < 4; ++i) {
            point.x = (i & 1) == 0 ? bounds.getMinX() : bounds.getMaxX();
            point.y = (i & 2) == 0 ? bounds.getMinY() : bounds.getMaxY();
            transform.transform(point, point);
            if (point.x < xmin) {
                xmin = point.x;
            }
            if (point.x > xmax) {
                xmax = point.x;
            }
            if (point.y < ymin) {
                ymin = point.y;
            }
            if (!(point.y > ymax)) continue;
            ymax = point.y;
        }
        if (dest != null) {
            dest.setRect(xmin, ymin, xmax - xmin, ymax - ymin);
            return dest;
        }
        return new Rectangle2D.Double(xmin, ymin, xmax - xmin, ymax - ymin);
    }
}

