/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.datum;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.metadata.extent.Extent;
import org.opengis.referencing.datum.Datum;
import org.opengis.util.InternationalString;

public class AbstractDatum
extends AbstractIdentifiedObject
implements Datum {
    private static final long serialVersionUID = -4894180465652474930L;
    private static final String[] LOCALIZABLES = new String[]{"anchorPoint", "scope"};
    private final InternationalString anchorPoint;
    private final long realizationEpoch;
    private final Extent domainOfValidity;
    private final InternationalString scope;

    public AbstractDatum(Map<String, ?> properties) {
        this(properties, new HashMap<String, Object>());
    }

    private AbstractDatum(Map<String, ?> properties, Map<String, Object> subProperties) {
        super(properties, subProperties, LOCALIZABLES);
        this.anchorPoint = (InternationalString)subProperties.get("anchorPoint");
        Date realizationEpoch = (Date)subProperties.get("realizationEpoch");
        this.domainOfValidity = (Extent)subProperties.get("domainOfValidity");
        this.scope = (InternationalString)subProperties.get("scope");
        this.realizationEpoch = realizationEpoch != null ? realizationEpoch.getTime() : Long.MIN_VALUE;
    }

    static Map<String, Object> name(int key) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        InternationalString name = Vocabulary.formatInternational(key);
        properties.put("name", name.toString(null));
        properties.put("alias", name);
        return properties;
    }

    public InternationalString getAnchorPoint() {
        return this.anchorPoint;
    }

    public Date getRealizationEpoch() {
        return this.realizationEpoch != Long.MIN_VALUE ? new Date(this.realizationEpoch) : null;
    }

    @Override
    public Extent getDomainOfValidity() {
        return this.domainOfValidity;
    }

    @Override
    public InternationalString getScope() {
        return this.scope;
    }

    int getLegacyDatumType() {
        return 0;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            if (!compareMetadata) {
                return this.nameMatches(object.getName().getCode()) || object.nameMatches(this.getName().getCode());
            }
            AbstractDatum that = (AbstractDatum)object;
            return this.realizationEpoch == that.realizationEpoch && Utilities.equals(this.domainOfValidity, that.domainOfValidity) && Utilities.equals(this.anchorPoint, that.anchorPoint) && Utilities.equals(this.scope, that.scope);
        }
        return false;
    }
}

