/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.factory;

import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.factory.FactoryCreator;
import org.geotools.factory.FactoryFinder;
import org.geotools.factory.FactoryRegistry;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollections;
import org.geotools.filter.FunctionFactory;
import org.geotools.resources.LazySet;
import org.opengis.feature.FeatureFactory;
import org.opengis.feature.type.FeatureTypeFactory;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Function;

public final class CommonFactoryFinder
extends FactoryFinder {
    private static FactoryRegistry registry;

    private CommonFactoryFinder() {
    }

    private static FactoryRegistry getServiceRegistry() {
        assert (Thread.holdsLock(CommonFactoryFinder.class));
        if (registry == null) {
            registry = new FactoryCreator(Arrays.asList(FilterFactory.class, FeatureLockFactory.class, FileDataStoreFactorySpi.class, Function.class, FunctionFactory.class, FeatureFactory.class, FeatureTypeFactory.class, FeatureCollections.class));
        }
        return registry;
    }

    public static synchronized Set getFunctionExpressions(Hints hints) {
        return Collections.EMPTY_SET;
    }

    public static synchronized Set getFunctions(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<Function>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(Function.class, null, hints));
    }

    public static synchronized Set<FunctionFactory> getFunctionFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<FunctionFactory>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FunctionFactory.class, null, hints));
    }

    public static synchronized Set getFileDataStoreFactories(Hints hints) {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return new LazySet<FileDataStoreFactorySpi>(CommonFactoryFinder.getServiceRegistry().getServiceProviders(FileDataStoreFactorySpi.class, null, hints));
    }

    public static FeatureFactory getFeatureFactory(Hints hints) {
        if ((hints = CommonFactoryFinder.mergeSystemHints(hints)).get(Hints.FEATURE_FACTORY) == null) {
            try {
                Class<?> lenient = Class.forName("org.geotools.feature.LenientFeatureFactoryImpl");
                hints.put(Hints.FEATURE_FACTORY, lenient);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return (FeatureFactory)CommonFactoryFinder.lookup(FeatureFactory.class, hints, Hints.FEATURE_FACTORY);
    }

    public static FilterFactory getFilterFactory(Hints hints) throws FactoryRegistryException {
        hints = CommonFactoryFinder.mergeSystemHints(hints);
        return (FilterFactory)CommonFactoryFinder.lookup(FilterFactory.class, hints, Hints.FILTER_FACTORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object lookup(Class category, Hints hints, Hints.Key key) {
        if (hints == null || key == null) {
            return null;
        }
        Object hint = hints.get(key);
        if (hint != null && category.isInstance(hint)) {
            return hint;
        }
        Class<CommonFactoryFinder> clazz = CommonFactoryFinder.class;
        synchronized (CommonFactoryFinder.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return CommonFactoryFinder.getServiceRegistry().getServiceProvider(category, null, hints, key);
        }
    }

    public static FilterFactory2 getFilterFactory2(Hints hints) throws FactoryRegistryException {
        Object h = (hints = CommonFactoryFinder.mergeSystemHints(hints)).get(Hints.FILTER_FACTORY);
        if (!(!(h instanceof Class) ? h instanceof FilterFactory2 : FilterFactory2.class.isAssignableFrom((Class)h))) {
            hints = new Hints(hints);
            hints.put(Hints.FILTER_FACTORY, FilterFactory2.class);
        }
        return (FilterFactory2)CommonFactoryFinder.getFilterFactory(hints);
    }
}

