/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.util.ShortCircuitedGeometryVisitor;

class EnvelopeIntersectsVisitor
extends ShortCircuitedGeometryVisitor {
    private Envelope rectEnv;
    private boolean intersects = false;

    public EnvelopeIntersectsVisitor(Envelope envelope) {
        this.rectEnv = envelope;
    }

    public boolean intersects() {
        return this.intersects;
    }

    @Override
    protected void visit(Geometry geometry) {
        Envelope envelope = geometry.getEnvelopeInternal();
        if (!this.rectEnv.intersects(envelope)) {
            return;
        }
        if (this.rectEnv.contains(envelope)) {
            this.intersects = true;
            return;
        }
        if (envelope.getMinX() >= this.rectEnv.getMinX() && envelope.getMaxX() <= this.rectEnv.getMaxX()) {
            this.intersects = true;
            return;
        }
        if (envelope.getMinY() >= this.rectEnv.getMinY() && envelope.getMaxY() <= this.rectEnv.getMaxY()) {
            this.intersects = true;
            return;
        }
    }

    @Override
    protected boolean isDone() {
        return this.intersects;
    }
}

