/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geomgraph.Edge;
import com.vividsolutions.jts.geomgraph.EdgeIntersection;
import com.vividsolutions.jts.geomgraph.Label;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EdgeIntersectionList {
    private Map nodeMap = new TreeMap();
    Edge edge;

    public EdgeIntersectionList(Edge edge) {
        this.edge = edge;
    }

    public EdgeIntersection add(Coordinate coordinate, int n, double d) {
        EdgeIntersection edgeIntersection = new EdgeIntersection(coordinate, n, d);
        EdgeIntersection edgeIntersection2 = (EdgeIntersection)this.nodeMap.get(edgeIntersection);
        if (edgeIntersection2 != null) {
            return edgeIntersection2;
        }
        this.nodeMap.put(edgeIntersection, edgeIntersection);
        return edgeIntersection;
    }

    public Iterator iterator() {
        return this.nodeMap.values().iterator();
    }

    public boolean isIntersection(Coordinate coordinate) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeIntersection edgeIntersection = (EdgeIntersection)iterator.next();
            if (!edgeIntersection.coord.equals(coordinate)) continue;
            return true;
        }
        return false;
    }

    public void addEndpoints() {
        int n = this.edge.pts.length - 1;
        this.add(this.edge.pts[0], 0, 0.0);
        this.add(this.edge.pts[n], n, 0.0);
    }

    public void addSplitEdges(List list) {
        this.addEndpoints();
        Iterator iterator = this.iterator();
        EdgeIntersection edgeIntersection = (EdgeIntersection)iterator.next();
        while (iterator.hasNext()) {
            EdgeIntersection edgeIntersection2 = (EdgeIntersection)iterator.next();
            Edge edge = this.createSplitEdge(edgeIntersection, edgeIntersection2);
            list.add(edge);
            edgeIntersection = edgeIntersection2;
        }
    }

    Edge createSplitEdge(EdgeIntersection edgeIntersection, EdgeIntersection edgeIntersection2) {
        boolean bl;
        int n = edgeIntersection2.segmentIndex - edgeIntersection.segmentIndex + 2;
        Coordinate coordinate = this.edge.pts[edgeIntersection2.segmentIndex];
        boolean bl2 = bl = edgeIntersection2.dist > 0.0 || !edgeIntersection2.coord.equals2D(coordinate);
        if (!bl) {
            --n;
        }
        Coordinate[] coordinateArray = new Coordinate[n];
        int n2 = 0;
        coordinateArray[n2++] = new Coordinate(edgeIntersection.coord);
        for (int i = edgeIntersection.segmentIndex + 1; i <= edgeIntersection2.segmentIndex; ++i) {
            coordinateArray[n2++] = this.edge.pts[i];
        }
        if (bl) {
            coordinateArray[n2] = edgeIntersection2.coord;
        }
        return new Edge(coordinateArray, new Label(this.edge.label));
    }
}

