/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets;

import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.DataGouvFrConstants;

public abstract class DataGouvDataSetHandler
extends FrenchDataSetHandler
implements DataGouvFrConstants {
    public DataGouvDataSetHandler() {
        this.init(null, null);
    }

    public DataGouvDataSetHandler(String portalPath) {
        this.init(portalPath, null);
    }

    public DataGouvDataSetHandler(String portalPath, Projection singleProjection) {
        this.init(portalPath, singleProjection);
    }

    public DataGouvDataSetHandler(String portalPath, Projection singleProjection, String relevantTag) {
        super(relevantTag);
        this.init(portalPath, singleProjection);
    }

    public DataGouvDataSetHandler(String portalPath, String relevantTag) {
        super(relevantTag);
        this.init(portalPath, null);
    }

    private void init(String portalPath, Projection singleProjection) {
        this.setNationalPortalPath(portalPath);
        this.setSingleProjection(singleProjection);
    }

    public String getSource() {
        return "data.gouv.fr";
    }

    public URL getLocalPortalURL() {
        return null;
    }

    public URL getLicenseURL() {
        try {
            return new URL("http://www.data.gouv.fr/Licence-Ouverte-Open-Licence");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final void setDownloadFileName(String filename) {
        try {
            this.setDataURL("http://www.data.gouv.fr/var/download/" + filename);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

