/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.util;

import java.util.ArrayList;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.tools.ImageProvider;

public abstract class OdUtils {
    public static final boolean isMultipolygon(OsmPrimitive p) {
        return p instanceof Relation && ((Relation)p).isMultipolygon();
    }

    public static final String[] stripQuotes(String[] split, String sep) {
        ArrayList<String> result = new ArrayList<String>();
        boolean append = false;
        for (int i = 0; i < split.length; ++i) {
            if (append) {
                int index = result.size() - 1;
                if (split[i].endsWith("\"") && StringUtils.countMatches(split[i], "\"") % 2 == 1) {
                    append = false;
                }
                result.set(index, (String)result.get(index) + sep + split[i].replaceAll("\"", ""));
                continue;
            }
            if (split[i].startsWith("\"")) {
                if (!split[i].endsWith("\"") || StringUtils.countMatches(split[i], "\"") % 2 != 0) {
                    append = true;
                }
                result.add(split[i].replaceAll("\"", ""));
                continue;
            }
            result.add(split[i]);
        }
        return result.toArray(new String[0]);
    }

    public static final ImageIcon getImageIcon(String iconName) {
        return new ImageProvider(iconName).setAdditionalClassLoaders(ModuleHandler.getResourceClassLoaders()).get();
    }
}

