/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.geotools.resources.Classes;

public final class Logging {
    final String name;

    private Logging() {
        this.name = "";
    }

    private Logging(Logging parent, String name) {
        this.name = name;
        assert (name.startsWith(parent.name)) : name;
    }

    public static Logger getLogger(Class<?> classe) {
        String name = classe.getName();
        int separator = name.lastIndexOf(46);
        name = separator >= 1 ? name.substring(0, separator) : "";
        return Logging.getLogger(name);
    }

    public static Logger getLogger(String name) {
        return Logger.getLogger(name);
    }

    public static boolean unexpectedException(Logger logger, Throwable error) {
        return Logging.unexpectedException(logger, null, null, error, Level.WARNING);
    }

    public static boolean unexpectedException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.WARNING);
    }

    public static boolean unexpectedException(String paquet, Class<?> classe, String method, Throwable error) {
        Logger logger = paquet != null ? Logging.getLogger(paquet) : null;
        return Logging.unexpectedException(logger, classe, method, error);
    }

    public static boolean unexpectedException(Class<?> classe, String method, Throwable error) {
        return Logging.unexpectedException((Logger)null, classe, method, error);
    }

    private static boolean unexpectedException(Logger logger, String classe, String method, Throwable error, Level level) {
        if (error == null) {
            return false;
        }
        if (logger == null && classe != null) {
            int separator = classe.lastIndexOf(46);
            String paquet = separator >= 1 ? classe.substring(0, separator - 1) : "";
            logger = Logging.getLogger(paquet);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        if (logger == null || classe == null || method == null) {
            String paquet = logger != null ? logger.getName() : null;
            StackTraceElement[] elements = error.getStackTrace();
            for (int i = 0; i < elements.length; ++i) {
                char separator;
                StackTraceElement element = elements[i];
                String classname = element.getClassName();
                if (classe != null) {
                    if (!classname.equals(classe)) {
                        continue;
                    }
                } else if (paquet != null) {
                    if (!classname.startsWith(paquet)) continue;
                    int length = paquet.length();
                    if (classname.length() > length && Character.isJavaIdentifierPart(separator = (char)classname.charAt(length))) continue;
                }
                String methodName = element.getMethodName();
                if (method != null && !methodName.equals(method)) continue;
                if (paquet == null && !(logger = Logging.getLogger(paquet = (separator = classname.lastIndexOf(46)) >= '\u0001' ? classname.substring(0, separator - '\u0001') : "")).isLoggable(level)) {
                    return false;
                }
                if (classe == null) {
                    classe = classname;
                }
                if (method != null) break;
                method = methodName;
                break;
            }
            if (logger == null && !(logger = Logging.getLogger("global")).isLoggable(level)) {
                return false;
            }
        }
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(error));
        String message = error.getLocalizedMessage();
        if (message != null) {
            buffer.append(": ").append(message);
        }
        LogRecord record = new LogRecord(level, buffer.toString());
        if (classe != null) {
            record.setSourceClassName(classe);
        }
        if (method != null) {
            record.setSourceMethodName(method);
        }
        if (level.intValue() > 500) {
            record.setThrown(error);
        }
        record.setLoggerName(logger.getName());
        logger.log(record);
        return true;
    }

    public static boolean recoverableException(Logger logger, Class<?> classe, String method, Throwable error) {
        String classname = classe != null ? classe.getName() : null;
        return Logging.unexpectedException(logger, classname, method, error, Level.FINE);
    }
}

