/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.logging;

import java.util.Locale;
import java.util.logging.Level;
import org.geotools.resources.i18n.Errors;

public class LoggedFormat {
    public static String formatUnparsable(String text, int index, int errorIndex, Locale locale) {
        return (String)LoggedFormat.doFormatUnparsable(text, index, errorIndex, locale, null);
    }

    private static Object doFormatUnparsable(String text, int index, int errorIndex, Locale locale, Level level) {
        Errors resources = Errors.getResources(locale);
        int length = text.length();
        if (errorIndex < index) {
            errorIndex = index;
        }
        if (errorIndex == length) {
            if (level != null) {
                return resources.getLogRecord(level, 174);
            }
            return resources.getString(174);
        }
        int upper = errorIndex;
        if (upper < length) {
            int type = Character.getType(text.charAt(upper));
            while (++upper < length && Character.getType(text.charAt(upper)) == type) {
            }
        }
        String error = text.substring(errorIndex, upper);
        text = text.substring(index);
        if (level != null) {
            return resources.getLogRecord(level, 192, text, error);
        }
        return resources.getString(192, text, error);
    }
}

