/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry.jts;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import org.geotools.referencing.CRS;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ReferencedEnvelope
extends Envelope
implements BoundingBox {
    public static ReferencedEnvelope EVERYTHING = new ReferencedEnvelope(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, null){
        private static final long serialVersionUID = -3188702602373537164L;

        @Override
        public boolean contains(BoundingBox bbox) {
            return true;
        }

        @Override
        public boolean contains(Coordinate p) {
            return true;
        }

        @Override
        public boolean contains(DirectPosition pos) {
            return true;
        }

        @Override
        public boolean contains(double x, double y) {
            return true;
        }

        @Override
        public boolean contains(Envelope other) {
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public double getArea() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public void setBounds(BoundingBox arg0) {
            throw new IllegalStateException("Cannot modify ReferencedEnvelope.EVERYTHING");
        }

        @Override
        public Coordinate centre() {
            return new Coordinate();
        }

        @Override
        public void setToNull() {
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == EVERYTHING) {
                return true;
            }
            if (obj instanceof ReferencedEnvelope) {
                ReferencedEnvelope other = (ReferencedEnvelope)obj;
                if (other.crs != EVERYTHING.crs) {
                    return false;
                }
                if (other.getMinX() != EVERYTHING.getMinX()) {
                    return false;
                }
                if (other.getMinY() != EVERYTHING.getMinY()) {
                    return false;
                }
                if (other.getMaxX() != EVERYTHING.getMaxX()) {
                    return false;
                }
                return other.getMaxY() == EVERYTHING.getMaxY();
            }
            return super.equals(obj);
        }

        @Override
        public String toString() {
            return "ReferencedEnvelope.EVERYTHING";
        }
    };
    private static final long serialVersionUID = -3188702602373537163L;
    private CoordinateReferenceSystem crs;

    public ReferencedEnvelope() {
        this((CoordinateReferenceSystem)null);
    }

    public ReferencedEnvelope(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(double x1, double x2, double y1, double y2, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(x1, x2, y1, y2);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public ReferencedEnvelope(BoundingBox bbox) throws MismatchedDimensionException {
        this(bbox.getMinX(), bbox.getMaxX(), bbox.getMinY(), bbox.getMaxY(), bbox.getCoordinateReferenceSystem());
    }

    public ReferencedEnvelope(Envelope envelope, CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        super(envelope);
        this.crs = crs;
        this.checkCoordinateReferenceSystemDimension();
    }

    public void init(BoundingBox bounds) {
        super.init(bounds.getMinimum(0), bounds.getMaximum(0), bounds.getMinimum(1), bounds.getMaximum(1));
        this.crs = bounds.getCoordinateReferenceSystem();
    }

    private static Envelope getJTSEnvelope(BoundingBox bbox) {
        if (bbox == null) {
            throw new NullPointerException("Provided bbox envelope was null");
        }
        if (bbox instanceof Envelope) {
            return (Envelope)((Object)bbox);
        }
        return new ReferencedEnvelope(bbox);
    }

    private void checkCoordinateReferenceSystemDimension() throws MismatchedDimensionException {
        if (this.crs != null) {
            int expected = this.getDimension();
            int dimension = this.crs.getCoordinateSystem().getDimension();
            if (dimension != expected) {
                throw new MismatchedDimensionException(Errors.format(94, this.crs.getName().getCode(), new Integer(dimension), new Integer(expected)));
            }
        }
    }

    private void ensureCompatibleReferenceSystem(BoundingBox bbox) throws MismatchedReferenceSystemException {
        CoordinateReferenceSystem other;
        if (this.crs != null && (other = bbox.getCoordinateReferenceSystem()) != null && !CRS.equalsIgnoreMetadata(this.crs, other)) {
            throw new MismatchedReferenceSystemException(Errors.format(92));
        }
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public double getMinimum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMinX();
            }
            case 1: {
                return this.getMinY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getMaximum(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getMaxX();
            }
            case 1: {
                return this.getMaxY();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getCenter(int dimension) {
        return this.getMedian(dimension);
    }

    @Override
    public double getMedian(int dimension) {
        switch (dimension) {
            case 0: {
                return 0.5 * (this.getMinX() + this.getMaxX());
            }
            case 1: {
                return 0.5 * (this.getMinY() + this.getMaxY());
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public double getLength(int dimension) {
        return this.getSpan(dimension);
    }

    @Override
    public double getSpan(int dimension) {
        switch (dimension) {
            case 0: {
                return this.getWidth();
            }
            case 1: {
                return this.getHeight();
            }
        }
        throw new IndexOutOfBoundsException(String.valueOf(dimension));
    }

    @Override
    public boolean isEmpty() {
        return super.isNull();
    }

    public boolean contains(DirectPosition pos) {
        return super.contains(pos.getOrdinate(0), pos.getOrdinate(1));
    }

    public boolean contains(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        return super.contains(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    @Override
    public Envelope intersection(Envelope env) {
        if (env instanceof BoundingBox) {
            BoundingBox bbox = (BoundingBox)((Object)env);
            this.ensureCompatibleReferenceSystem(bbox);
        }
        return super.intersection(env);
    }

    @Override
    public void include(BoundingBox bbox) {
        if (this.crs == null) {
            this.crs = bbox.getCoordinateReferenceSystem();
        } else {
            this.ensureCompatibleReferenceSystem(bbox);
        }
        super.expandToInclude(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    @Override
    public void expandToInclude(Envelope other) {
        if (other instanceof BoundingBox) {
            BoundingBox bbox = (BoundingBox)((Object)other);
            this.ensureCompatibleReferenceSystem(bbox);
        }
        super.expandToInclude(other);
    }

    @Override
    public void include(double x, double y) {
        super.expandToInclude(x, y);
    }

    public void setBounds(BoundingBox bbox) {
        this.ensureCompatibleReferenceSystem(bbox);
        super.init(ReferencedEnvelope.getJTSEnvelope(bbox));
    }

    @Override
    public int hashCode() {
        int code = super.hashCode() ^ 0xAB296275;
        if (this.crs != null) {
            code ^= this.crs.hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (super.equals(object)) {
            CoordinateReferenceSystem otherCRS;
            CoordinateReferenceSystem coordinateReferenceSystem = otherCRS = object instanceof ReferencedEnvelope ? ((ReferencedEnvelope)object).crs : null;
            if (otherCRS == null) {
                return this.crs == null;
            }
            return CRS.equalsIgnoreMetadata(this.crs, otherCRS);
        }
        return false;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this)).append('[');
        int dimension = this.getDimension();
        for (int i = 0; i < dimension; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.getMinimum(i)).append(" : ").append(this.getMaximum(i));
        }
        return buffer.append(']').toString();
    }

    public static ReferencedEnvelope reference(Envelope e) {
        if (e == null) {
            return null;
        }
        if (e instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)e;
        }
        return new ReferencedEnvelope(e, null);
    }

    public static ReferencedEnvelope reference(BoundingBox e) {
        if (e == null) {
            return null;
        }
        if (e instanceof ReferencedEnvelope) {
            return (ReferencedEnvelope)e;
        }
        return new ReferencedEnvelope(e);
    }
}

