/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.util.HashMap;
import java.util.Map;
import org.geotools.util.Utilities;
import org.opengis.feature.Property;
import org.opengis.feature.type.Name;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.feature.type.PropertyType;

public abstract class PropertyImpl
implements Property {
    protected Object value;
    protected PropertyDescriptor descriptor;
    protected final Map<Object, Object> userData;

    protected PropertyImpl(Object value, PropertyDescriptor descriptor) {
        this.value = value;
        this.descriptor = descriptor;
        this.userData = new HashMap<Object, Object>();
        if (descriptor == null) {
            throw new NullPointerException("descriptor");
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public Name getName() {
        return this.getDescriptor().getName();
    }

    @Override
    public PropertyType getType() {
        return this.getDescriptor().getType();
    }

    @Override
    public boolean isNillable() {
        return this.getDescriptor().isNillable();
    }

    @Override
    public Map<Object, Object> getUserData() {
        return this.userData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof PropertyImpl)) {
            return false;
        }
        PropertyImpl other = (PropertyImpl)obj;
        if (!Utilities.equals(this.descriptor, other.descriptor)) {
            return false;
        }
        return Utilities.deepEquals(this.value, other.value);
    }

    public int hashCode() {
        return 37 * this.descriptor.hashCode() + 37 * (this.value == null ? 0 : this.value.hashCode());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getClass().getSimpleName()).append(":");
        sb.append(this.getDescriptor().getName().getLocalPart());
        sb.append("<");
        sb.append(this.getDescriptor().getType().getName().getLocalPart());
        sb.append(">=");
        sb.append(this.value);
        return sb.toString();
    }
}

