/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.feature;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.factory.FactoryRegistryException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureTypes {
    public static final URI DEFAULT_NAMESPACE;
    public static final SimpleFeatureType ABSTRACT_FEATURE_TYPE;

    public static SimpleFeatureType transform(SimpleFeatureType schema, CoordinateReferenceSystem crs) throws SchemaException {
        return FeatureTypes.transform(schema, crs, false);
    }

    public static SimpleFeatureType transform(SimpleFeatureType schema, CoordinateReferenceSystem crs, boolean forceOnlyMissing) throws SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(schema.getTypeName());
        tb.setNamespaceURI(schema.getName().getNamespaceURI());
        tb.setAbstract(schema.isAbstract());
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = schema.getDescriptor(i);
            if (attributeType instanceof GeometryDescriptor) {
                GeometryDescriptor geometryType = (GeometryDescriptor)attributeType;
                tb.descriptor(geometryType);
                if (!forceOnlyMissing || geometryType.getCoordinateReferenceSystem() == null) {
                    tb.crs(crs);
                }
                tb.add(geometryType.getLocalName(), geometryType.getType().getBinding());
                continue;
            }
            tb.add(attributeType);
        }
        if (schema.getGeometryDescriptor() != null) {
            tb.setDefaultGeometry(schema.getGeometryDescriptor().getLocalName());
        }
        tb.setSuperType((SimpleFeatureType)schema.getSuper());
        return tb.buildFeatureType();
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, null);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes, AttributeDescriptor defaultGeometry) throws FactoryRegistryException, SchemaException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(name);
        tb.setNamespaceURI(ns);
        tb.setAbstract(isAbstract);
        if (types != null) {
            tb.addAll(types);
        }
        if (defaultGeometry != null) {
            boolean add = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] != defaultGeometry) continue;
                add = false;
                break;
            }
            if (add) {
                tb.add(defaultGeometry);
            }
            tb.setDefaultGeometry(defaultGeometry.getLocalName());
        }
        if (superTypes != null && superTypes.length > 0) {
            if (superTypes.length > 1) {
                throw new SchemaException("Can only specify a single super type");
            }
            tb.setSuperType(superTypes[0]);
        } else {
            tb.setSuperType(ABSTRACT_FEATURE_TYPE);
        }
        return tb.buildFeatureType();
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract, SimpleFeatureType[] superTypes, GeometryDescriptor defaultGeometry) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, superTypes, (AttributeDescriptor)defaultGeometry);
    }

    public static SimpleFeatureType newFeatureType(AttributeDescriptor[] types, String name, URI ns, boolean isAbstract) throws FactoryRegistryException, SchemaException {
        return FeatureTypes.newFeatureType(types, name, ns, isAbstract, null);
    }

    public static List<FeatureType> getAncestors(FeatureType featureType) {
        ArrayList<FeatureType> ancestors = new ArrayList<FeatureType>();
        while (featureType.getSuper() instanceof FeatureType) {
            FeatureType superType = (FeatureType)featureType.getSuper();
            ancestors.add(superType);
            featureType = superType;
        }
        return ancestors;
    }

    public static boolean equalsExact(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        return FeatureTypes.equals(typeA, typeB, true);
    }

    static boolean equals(SimpleFeatureType typeA, SimpleFeatureType typeB, boolean compareUserMaps) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        if (compareUserMaps && !FeatureTypes.equals(typeA.getUserData(), typeB.getUserData())) {
            return false;
        }
        return FeatureTypes.equalsId(typeA, typeB) && FeatureTypes.equals(typeA.getAttributeDescriptors(), typeB.getAttributeDescriptors(), compareUserMaps) && FeatureTypes.equalsAncestors(typeA, typeB);
    }

    static boolean equals(List attributesA, List attributesB, boolean compareUserMaps) {
        return FeatureTypes.equals(attributesA.toArray(new AttributeDescriptor[attributesA.size()]), attributesB.toArray(new AttributeDescriptor[attributesB.size()]), compareUserMaps);
    }

    static boolean equals(AttributeDescriptor[] attributesA, AttributeDescriptor[] attributesB, boolean compareUserMaps) {
        if (attributesA.length != attributesB.length) {
            return false;
        }
        int length = attributesA.length;
        for (int i = 0; i < length; ++i) {
            if (FeatureTypes.equals(attributesA[i], attributesB[i], compareUserMaps)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsAncestors(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        return ((Object)FeatureTypes.ancestors(typeA)).equals(FeatureTypes.ancestors(typeB));
    }

    public static Set ancestors(SimpleFeatureType featureType) {
        if (featureType == null || FeatureTypes.getAncestors(featureType).isEmpty()) {
            return Collections.EMPTY_SET;
        }
        return new HashSet<FeatureType>(FeatureTypes.getAncestors(featureType));
    }

    static boolean equals(AttributeDescriptor a, AttributeDescriptor b, boolean compareUserMaps) {
        if (a == b) {
            return true;
        }
        if (a == null) {
            return true;
        }
        if (!a.equals(b)) {
            return false;
        }
        if (compareUserMaps) {
            if (!FeatureTypes.equals(a.getUserData(), b.getUserData())) {
                return false;
            }
            if (!FeatureTypes.equals(a.getType().getUserData(), b.getType().getUserData())) {
                return false;
            }
        }
        return true;
    }

    static boolean equals(Map a, Map b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return ((Object)a).equals(b);
    }

    public static boolean equalsId(SimpleFeatureType typeA, SimpleFeatureType typeB) {
        if (typeA == typeB) {
            return true;
        }
        if (typeA == null || typeB == null) {
            return false;
        }
        String typeNameA = typeA.getTypeName();
        String typeNameB = typeB.getTypeName();
        if (typeNameA == null && typeNameB != null) {
            return false;
        }
        if (!typeNameA.equals(typeNameB)) {
            return false;
        }
        String namespaceA = typeA.getName().getNamespaceURI();
        String namespaceB = typeB.getName().getNamespaceURI();
        if (namespaceA == null && namespaceB == null) {
            return true;
        }
        if (namespaceA == null && namespaceB != null) {
            return false;
        }
        return namespaceA.equals(namespaceB);
    }

    static {
        URI uri;
        try {
            uri = new URI("http://www.opengis.net/gml");
        }
        catch (URISyntaxException e) {
            uri = null;
        }
        DEFAULT_NAMESPACE = uri;
        SimpleFeatureType featureType = null;
        try {
            featureType = FeatureTypes.newFeatureType(null, "Feature", new URI("http://www.opengis.net/gml"), true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ABSTRACT_FEATURE_TYPE = featureType;
    }
}

