/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.precision;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateFilter;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.precision.CommonBits;

public class CommonBitsRemover {
    private Coordinate commonCoord;
    private CommonCoordinateFilter ccFilter = new CommonCoordinateFilter();

    public void add(Geometry geometry) {
        geometry.apply(this.ccFilter);
        this.commonCoord = this.ccFilter.getCommonCoordinate();
    }

    public Coordinate getCommonCoordinate() {
        return this.commonCoord;
    }

    public Geometry removeCommonBits(Geometry geometry) {
        if (this.commonCoord.x == 0.0 && this.commonCoord.y == 0.0) {
            return geometry;
        }
        Coordinate coordinate = new Coordinate(this.commonCoord);
        coordinate.x = -coordinate.x;
        coordinate.y = -coordinate.y;
        Translater translater = new Translater(coordinate);
        geometry.apply(translater);
        geometry.geometryChanged();
        return geometry;
    }

    public void addCommonBits(Geometry geometry) {
        Translater translater = new Translater(this.commonCoord);
        geometry.apply(translater);
        geometry.geometryChanged();
    }

    class Translater
    implements CoordinateFilter {
        Coordinate trans = null;

        public Translater(Coordinate coordinate) {
            this.trans = coordinate;
        }

        @Override
        public void filter(Coordinate coordinate) {
            coordinate.x += this.trans.x;
            coordinate.y += this.trans.y;
        }
    }

    class CommonCoordinateFilter
    implements CoordinateFilter {
        private CommonBits commonBitsX = new CommonBits();
        private CommonBits commonBitsY = new CommonBits();

        CommonCoordinateFilter() {
        }

        @Override
        public void filter(Coordinate coordinate) {
            this.commonBitsX.add(coordinate.x);
            this.commonBitsY.add(coordinate.y);
        }

        public Coordinate getCommonCoordinate() {
            return new Coordinate(this.commonBitsX.getCommon(), this.commonBitsY.getCommon());
        }
    }
}

