/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.locate.IndexedPointInAreaLocator;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.prep.BasicPreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedPolygonContains;
import com.vividsolutions.jts.geom.prep.PreparedPolygonContainsProperly;
import com.vividsolutions.jts.geom.prep.PreparedPolygonCovers;
import com.vividsolutions.jts.geom.prep.PreparedPolygonIntersects;
import com.vividsolutions.jts.noding.FastSegmentSetIntersectionFinder;
import com.vividsolutions.jts.noding.SegmentStringUtil;
import com.vividsolutions.jts.operation.predicate.RectangleContains;
import com.vividsolutions.jts.operation.predicate.RectangleIntersects;

public class PreparedPolygon
extends BasicPreparedGeometry {
    private boolean isRectangle = this.getGeometry().isRectangle();
    private FastSegmentSetIntersectionFinder segIntFinder = null;
    private PointOnGeometryLocator pia = null;

    public PreparedPolygon(Polygonal polygonal) {
        super((Geometry)((Object)polygonal));
    }

    public FastSegmentSetIntersectionFinder getIntersectionFinder() {
        if (this.segIntFinder == null) {
            this.segIntFinder = new FastSegmentSetIntersectionFinder(SegmentStringUtil.extractSegmentStrings(this.getGeometry()));
        }
        return this.segIntFinder;
    }

    public PointOnGeometryLocator getPointLocator() {
        if (this.pia == null) {
            this.pia = new IndexedPointInAreaLocator(this.getGeometry());
        }
        return this.pia;
    }

    @Override
    public boolean intersects(Geometry geometry) {
        if (!this.envelopesIntersect(geometry)) {
            return false;
        }
        if (this.isRectangle) {
            return RectangleIntersects.intersects((Polygon)this.getGeometry(), geometry);
        }
        return PreparedPolygonIntersects.intersects(this, geometry);
    }

    @Override
    public boolean contains(Geometry geometry) {
        if (!this.envelopeCovers(geometry)) {
            return false;
        }
        if (this.isRectangle) {
            return RectangleContains.contains((Polygon)this.getGeometry(), geometry);
        }
        return PreparedPolygonContains.contains(this, geometry);
    }

    @Override
    public boolean containsProperly(Geometry geometry) {
        if (!this.envelopeCovers(geometry)) {
            return false;
        }
        return PreparedPolygonContainsProperly.containsProperly(this, geometry);
    }

    @Override
    public boolean covers(Geometry geometry) {
        if (!this.envelopeCovers(geometry)) {
            return false;
        }
        if (this.isRectangle) {
            return true;
        }
        return PreparedPolygonCovers.covers(this, geometry);
    }
}

