/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.impl;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Envelope;
import java.io.Serializable;

public class CoordinateArraySequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = -915438501601840650L;
    private Coordinate[] coordinates;

    public CoordinateArraySequence(Coordinate[] coordinateArray) {
        this.coordinates = coordinateArray;
        if (coordinateArray == null) {
            this.coordinates = new Coordinate[0];
        }
    }

    public CoordinateArraySequence(int n) {
        this.coordinates = new Coordinate[n];
        for (int i = 0; i < n; ++i) {
            this.coordinates[i] = new Coordinate();
        }
    }

    @Override
    public int getDimension() {
        return 3;
    }

    @Override
    public Coordinate getCoordinate(int n) {
        return this.coordinates[n];
    }

    @Override
    public void getCoordinate(int n, Coordinate coordinate) {
        coordinate.x = this.coordinates[n].x;
        coordinate.y = this.coordinates[n].y;
        coordinate.z = this.coordinates[n].z;
    }

    @Override
    public double getX(int n) {
        return this.coordinates[n].x;
    }

    @Override
    public double getY(int n) {
        return this.coordinates[n].y;
    }

    @Override
    public double getOrdinate(int n, int n2) {
        switch (n2) {
            case 0: {
                return this.coordinates[n].x;
            }
            case 1: {
                return this.coordinates[n].y;
            }
            case 2: {
                return this.coordinates[n].z;
            }
        }
        return Double.NaN;
    }

    @Override
    public Object clone() {
        Coordinate[] coordinateArray = new Coordinate[this.size()];
        for (int i = 0; i < this.coordinates.length; ++i) {
            coordinateArray[i] = (Coordinate)this.coordinates[i].clone();
        }
        return new CoordinateArraySequence(coordinateArray);
    }

    @Override
    public int size() {
        return this.coordinates.length;
    }

    @Override
    public void setOrdinate(int n, int n2, double d) {
        switch (n2) {
            case 0: {
                this.coordinates[n].x = d;
                break;
            }
            case 1: {
                this.coordinates[n].y = d;
                break;
            }
            case 2: {
                this.coordinates[n].z = d;
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid ordinateIndex");
            }
        }
    }

    @Override
    public Coordinate[] toCoordinateArray() {
        return this.coordinates;
    }

    @Override
    public Envelope expandEnvelope(Envelope envelope) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            envelope.expandToInclude(this.coordinates[i]);
        }
        return envelope;
    }

    public String toString() {
        if (this.coordinates.length > 0) {
            StringBuffer stringBuffer = new StringBuffer(17 * this.coordinates.length);
            stringBuffer.append('(');
            stringBuffer.append(this.coordinates[0]);
            for (int i = 1; i < this.coordinates.length; ++i) {
                stringBuffer.append(", ");
                stringBuffer.append(this.coordinates[i]);
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        return "()";
    }
}

