/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.algorithm.locate;

import com.vividsolutions.jts.algorithm.RayCrossingCounter;
import com.vividsolutions.jts.algorithm.locate.PointOnGeometryLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineSegment;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.util.LinearComponentExtracter;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.intervalrtree.SortedPackedIntervalRTree;
import java.util.List;

public class IndexedPointInAreaLocator
implements PointOnGeometryLocator {
    private IntervalIndexedGeometry index;

    public IndexedPointInAreaLocator(Geometry geometry) {
        if (!(geometry instanceof Polygonal)) {
            throw new IllegalArgumentException("Argument must be Polygonal");
        }
        this.buildIndex(geometry);
    }

    private void buildIndex(Geometry geometry) {
        this.index = new IntervalIndexedGeometry(geometry);
    }

    @Override
    public int locate(Coordinate coordinate) {
        RayCrossingCounter rayCrossingCounter = new RayCrossingCounter(coordinate);
        SegmentVisitor segmentVisitor = new SegmentVisitor(rayCrossingCounter);
        this.index.query(coordinate.y, coordinate.y, segmentVisitor);
        return rayCrossingCounter.getLocation();
    }

    private static class IntervalIndexedGeometry {
        private SortedPackedIntervalRTree index = new SortedPackedIntervalRTree();

        public IntervalIndexedGeometry(Geometry geometry) {
            this.init(geometry);
        }

        private void init(Geometry geometry) {
            List list = LinearComponentExtracter.getLines(geometry);
            for (LineString lineString : list) {
                Coordinate[] coordinateArray = lineString.getCoordinates();
                this.addLine(coordinateArray);
            }
        }

        private void addLine(Coordinate[] coordinateArray) {
            for (int i = 1; i < coordinateArray.length; ++i) {
                LineSegment lineSegment = new LineSegment(coordinateArray[i - 1], coordinateArray[i]);
                double d = Math.min(lineSegment.p0.y, lineSegment.p1.y);
                double d2 = Math.max(lineSegment.p0.y, lineSegment.p1.y);
                this.index.insert(d, d2, lineSegment);
            }
        }

        public void query(double d, double d2, ItemVisitor itemVisitor) {
            this.index.query(d, d2, itemVisitor);
        }
    }

    private static class SegmentVisitor
    implements ItemVisitor {
        private RayCrossingCounter counter;

        public SegmentVisitor(RayCrossingCounter rayCrossingCounter) {
            this.counter = rayCrossingCounter;
        }

        @Override
        public void visitItem(Object object) {
            LineSegment lineSegment = (LineSegment)object;
            this.counter.countSegment(lineSegment.getCoordinate(0), lineSegment.getCoordinate(1));
        }
    }
}

