/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;

public abstract class DataSetUpdater
implements OdConstants {
    public static final void updateDataSet(DataSet dataSet, AbstractDataSetHandler handler, File associatedFile) {
        if (dataSet != null && handler != null) {
            if (associatedFile != null) {
                handler.setAssociatedFile(associatedFile);
                long lastmodified = associatedFile.lastModified();
                if (lastmodified > 0L) {
                    handler.setSourceDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date(lastmodified)));
                }
            }
            if (!Main.pref.getBoolean("opendata.rawdata")) {
                handler.updateDataSet(dataSet);
            }
            handler.checkDataSetSource(dataSet);
            handler.checkNames(dataSet);
        }
    }
}

