/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.converter;

import javax.measure.converter.MultiplyConverter;
import javax.measure.converter.UnitConverter;

public final class RationalConverter
extends UnitConverter {
    private final long _dividend;
    private final long _divisor;
    private static final long serialVersionUID = 1L;

    public RationalConverter(long l, long l2) {
        if (l2 < 0L) {
            throw new IllegalArgumentException("Negative divisor");
        }
        if (l == l2) {
            throw new IllegalArgumentException("Identity converter not allowed");
        }
        this._dividend = l;
        this._divisor = l2;
    }

    public long getDividend() {
        return this._dividend;
    }

    public long getDivisor() {
        return this._divisor;
    }

    @Override
    public UnitConverter inverse() {
        return this._dividend < 0L ? new RationalConverter(-this._divisor, -this._dividend) : new RationalConverter(this._divisor, this._dividend);
    }

    @Override
    public double convert(double d) {
        return d * (double)this._dividend / (double)this._divisor;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public UnitConverter concatenate(UnitConverter unitConverter) {
        if (unitConverter instanceof RationalConverter) {
            RationalConverter rationalConverter = (RationalConverter)unitConverter;
            long l = this._dividend * rationalConverter._dividend;
            long l2 = this._divisor * rationalConverter._divisor;
            double d = (double)this._dividend * (double)rationalConverter._dividend;
            double d2 = (double)this._divisor * (double)rationalConverter._divisor;
            if ((double)l != d || (double)l2 != d2) {
                return new MultiplyConverter(d / d2);
            }
            long l3 = RationalConverter.gcd(l, l2);
            return RationalConverter.valueOf(l / l3, l2 / l3);
        }
        if (unitConverter instanceof MultiplyConverter) {
            return unitConverter.concatenate(this);
        }
        return super.concatenate(unitConverter);
    }

    private static UnitConverter valueOf(long l, long l2) {
        return l == 1L && l2 == 1L ? UnitConverter.IDENTITY : new RationalConverter(l, l2);
    }

    private static long gcd(long l, long l2) {
        if (l2 == 0L) {
            return l;
        }
        return RationalConverter.gcd(l2, l % l2);
    }
}

