/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.predicate;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.operation.predicate.ContainsPointVisitor;
import com.vividsolutions.jts.operation.predicate.EnvelopeIntersectsVisitor;
import com.vividsolutions.jts.operation.predicate.LineIntersectsVisitor;

public class RectangleIntersects {
    private Polygon rectangle;
    private Envelope rectEnv;

    public static boolean intersects(Polygon polygon, Geometry geometry) {
        RectangleIntersects rectangleIntersects = new RectangleIntersects(polygon);
        return rectangleIntersects.intersects(geometry);
    }

    public RectangleIntersects(Polygon polygon) {
        this.rectangle = polygon;
        this.rectEnv = polygon.getEnvelopeInternal();
    }

    public boolean intersects(Geometry geometry) {
        if (!this.rectEnv.intersects(geometry.getEnvelopeInternal())) {
            return false;
        }
        EnvelopeIntersectsVisitor envelopeIntersectsVisitor = new EnvelopeIntersectsVisitor(this.rectEnv);
        envelopeIntersectsVisitor.applyTo(geometry);
        if (envelopeIntersectsVisitor.intersects()) {
            return true;
        }
        ContainsPointVisitor containsPointVisitor = new ContainsPointVisitor(this.rectangle);
        containsPointVisitor.applyTo(geometry);
        if (containsPointVisitor.containsPoint()) {
            return true;
        }
        LineIntersectsVisitor lineIntersectsVisitor = new LineIntersectsVisitor(this.rectangle);
        lineIntersectsVisitor.applyTo(geometry);
        return lineIntersectsVisitor.intersects();
    }
}

