/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geomgraph;

import com.vividsolutions.jts.algorithm.BoundaryNodeRule;
import com.vividsolutions.jts.algorithm.locate.SimplePointInAreaLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.TopologyException;
import com.vividsolutions.jts.geomgraph.EdgeEnd;
import com.vividsolutions.jts.geomgraph.GeometryGraph;
import com.vividsolutions.jts.geomgraph.Label;
import com.vividsolutions.jts.util.Assert;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public abstract class EdgeEndStar {
    protected Map edgeMap = new TreeMap();
    protected List edgeList;
    private int[] ptInAreaLocation = new int[]{-1, -1};

    public abstract void insert(EdgeEnd var1);

    protected void insertEdgeEnd(EdgeEnd edgeEnd, Object object) {
        this.edgeMap.put(edgeEnd, object);
        this.edgeList = null;
    }

    public Coordinate getCoordinate() {
        Iterator iterator = this.iterator();
        if (!iterator.hasNext()) {
            return null;
        }
        EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
        return edgeEnd.getCoordinate();
    }

    public int getDegree() {
        return this.edgeMap.size();
    }

    public Iterator iterator() {
        return this.getEdges().iterator();
    }

    public List getEdges() {
        if (this.edgeList == null) {
            this.edgeList = new ArrayList(this.edgeMap.values());
        }
        return this.edgeList;
    }

    public void computeLabelling(GeometryGraph[] geometryGraphArray) {
        int n;
        Label label;
        EdgeEnd edgeEnd;
        this.computeEdgeEndLabels(geometryGraphArray[0].getBoundaryNodeRule());
        this.propagateSideLabels(0);
        this.propagateSideLabels(1);
        boolean[] blArray = new boolean[]{false, false};
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            edgeEnd = (EdgeEnd)iterator.next();
            label = edgeEnd.getLabel();
            for (n = 0; n < 2; ++n) {
                if (!label.isLine(n) || label.getLocation(n) != 1) continue;
                blArray[n] = true;
            }
        }
        iterator = this.iterator();
        while (iterator.hasNext()) {
            edgeEnd = (EdgeEnd)iterator.next();
            label = edgeEnd.getLabel();
            for (n = 0; n < 2; ++n) {
                if (!label.isAnyNull(n)) continue;
                int n2 = -1;
                if (blArray[n]) {
                    n2 = 2;
                } else {
                    Coordinate coordinate = edgeEnd.getCoordinate();
                    n2 = this.getLocation(n, coordinate, geometryGraphArray);
                }
                label.setAllLocationsIfNull(n, n2);
            }
        }
    }

    private void computeEdgeEndLabels(BoundaryNodeRule boundaryNodeRule) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            edgeEnd.computeLabel(boundaryNodeRule);
        }
    }

    private int getLocation(int n, Coordinate coordinate, GeometryGraph[] geometryGraphArray) {
        if (this.ptInAreaLocation[n] == -1) {
            this.ptInAreaLocation[n] = SimplePointInAreaLocator.locate(coordinate, geometryGraphArray[n].getGeometry());
        }
        return this.ptInAreaLocation[n];
    }

    public boolean isAreaLabelsConsistent(GeometryGraph geometryGraph) {
        this.computeEdgeEndLabels(geometryGraph.getBoundaryNodeRule());
        return this.checkAreaLabelsConsistent(0);
    }

    private boolean checkAreaLabelsConsistent(int n) {
        List list = this.getEdges();
        if (list.size() <= 0) {
            return true;
        }
        int n2 = list.size() - 1;
        Label label = ((EdgeEnd)list.get(n2)).getLabel();
        int n3 = label.getLocation(n, 1);
        Assert.isTrue(n3 != -1, "Found unlabelled area edge");
        int n4 = n3;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            Label label2 = edgeEnd.getLabel();
            Assert.isTrue(label2.isArea(n), "Found non-area edge");
            int n5 = label2.getLocation(n, 1);
            int n6 = label2.getLocation(n, 2);
            if (n5 == n6) {
                return false;
            }
            if (n6 != n4) {
                return false;
            }
            n4 = n5;
        }
        return true;
    }

    void propagateSideLabels(int n) {
        Object object;
        Object object2;
        int n2 = -1;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            object2 = (EdgeEnd)iterator.next();
            object = ((EdgeEnd)object2).getLabel();
            if (!((Label)object).isArea(n) || ((Label)object).getLocation(n, 1) == -1) continue;
            n2 = ((Label)object).getLocation(n, 1);
        }
        if (n2 == -1) {
            return;
        }
        int n3 = n2;
        object2 = this.iterator();
        while (object2.hasNext()) {
            object = (EdgeEnd)object2.next();
            Label label = ((EdgeEnd)object).getLabel();
            if (label.getLocation(n, 0) == -1) {
                label.setLocation(n, 0, n3);
            }
            if (!label.isArea(n)) continue;
            int n4 = label.getLocation(n, 1);
            int n5 = label.getLocation(n, 2);
            if (n5 != -1) {
                if (n5 != n3) {
                    throw new TopologyException("side location conflict", ((EdgeEnd)object).getCoordinate());
                }
                if (n4 == -1) {
                    Assert.shouldNeverReachHere("found single null side (at " + ((EdgeEnd)object).getCoordinate() + ")");
                }
                n3 = n4;
                continue;
            }
            Assert.isTrue(label.getLocation(n, 1) == -1, "found single null side");
            label.setLocation(n, 2, n3);
            label.setLocation(n, 1, n3);
        }
    }

    public void print(PrintStream printStream) {
        System.out.println("EdgeEndStar:   " + this.getCoordinate());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            EdgeEnd edgeEnd = (EdgeEnd)iterator.next();
            edgeEnd.print(printStream);
        }
    }
}

