/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.datasets;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.AbstractDerivedCRS;
import org.geotools.referencing.datum.DefaultEllipsoid;
import org.geotools.referencing.operation.projection.LambertConformal;
import org.geotools.referencing.operation.projection.LambertConformal1SP;
import org.geotools.referencing.operation.projection.LambertConformal2SP;
import org.geotools.referencing.operation.projection.MapProjection;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.operation.MathTransform;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.Projections;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.DataSetCategory;
import org.openstreetmap.josm.plugins.opendata.core.util.NamesFrUtils;
import org.openstreetmap.josm.tools.Pair;

public abstract class AbstractDataSetHandler
implements OdConstants {
    private String name;
    private DataSetCategory category;
    private String sourceDate;
    private File associatedFile;
    private URL dataURL;
    private static final List<Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>> ellipsoids = new ArrayList<Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>>();

    public abstract boolean acceptsFilename(String var1);

    public boolean acceptsFile(File file) {
        return this.acceptsFilename(file.getName());
    }

    public abstract void updateDataSet(DataSet var1);

    public void checkDataSetSource(DataSet ds) {
        if (ds != null) {
            for (OsmPrimitive p : ds.allPrimitives()) {
                if (!p.hasKeys() && !p.getReferrers().isEmpty()) continue;
                if (this.getSource() != null && p.get("source") == null) {
                    p.put("source", this.getSource());
                }
                if (this.sourceDate == null || p.get("source:date") != null) continue;
                p.put("source:date", this.sourceDate);
            }
        }
    }

    public void checkNames(DataSet ds) {
        if (ds != null) {
            for (OsmPrimitive p : ds.allPrimitives()) {
                if (p.get("name") == null) continue;
                p.put("name", NamesFrUtils.checkDictionary(p.get("name")));
            }
        }
    }

    private final boolean acceptsFilename(String filename, String[] expected, String ... extensions) {
        if (filename != null) {
            for (String name : expected) {
                for (String ext : extensions) {
                    if (!Pattern.compile(name + "\\." + ext, 2).matcher(filename).matches()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected final boolean acceptsCsvFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "csv");
    }

    protected final boolean acceptsXlsFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "xls");
    }

    protected final boolean acceptsOdsFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "ods");
    }

    protected final boolean acceptsShpFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "shp");
    }

    protected final boolean acceptsMifFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "mif");
    }

    protected final boolean acceptsMifTabFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "mif", "tab");
    }

    protected final boolean acceptsShpMifFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "shp", "mif");
    }

    protected final boolean acceptsKmlFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "kml");
    }

    protected final boolean acceptsKmzFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "kmz");
    }

    protected final boolean acceptsKmzTabFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "kmz", "tab");
    }

    protected final boolean acceptsZipFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "zip");
    }

    protected final boolean acceptsCsvKmzFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "csv", "kmz");
    }

    protected final boolean acceptsCsvKmzTabFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "csv", "kmz", "tab");
    }

    protected final boolean acceptsCsvXlsFilename(String filename, String ... expected) {
        return this.acceptsFilename(filename, expected, "csv", "xls");
    }

    public URL getWikiURL() {
        return null;
    }

    public URL getLocalPortalURL() {
        return null;
    }

    public URL getNationalPortalURL() {
        return null;
    }

    public URL getLicenseURL() {
        return null;
    }

    public URL getDataURL() {
        return this.dataURL;
    }

    public final void setDataURL(String url) throws MalformedURLException {
        this.dataURL = new URL(url);
    }

    public final void setDataURL(URL url) {
        this.dataURL = url;
    }

    public List<Pair<String, URL>> getDataURLs() {
        return null;
    }

    public AbstractReader getReaderForUrl(String url) {
        return null;
    }

    public final DataSetCategory getCategory() {
        return this.category;
    }

    public final void setCategory(DataSetCategory category) {
        this.category = category;
    }

    public final Collection<String> getOsmXapiRequests(Bounds bounds) {
        return this.getOsmXapiRequests(LatLon.roundToOsmPrecisionStrict((double)bounds.getMin().lon()) + "," + LatLon.roundToOsmPrecisionStrict((double)bounds.getMin().lat()) + "," + LatLon.roundToOsmPrecisionStrict((double)bounds.getMax().lon()) + "," + LatLon.roundToOsmPrecisionStrict((double)bounds.getMax().lat()));
    }

    protected Collection<String> getOsmXapiRequests(String bbox) {
        return null;
    }

    public final String getOverpassApiRequest(Bounds bounds) {
        return this.getOverpassApiRequest("w=\"" + LatLon.roundToOsmPrecisionStrict((double)bounds.getMin().lon()) + "\" " + "s=\"" + LatLon.roundToOsmPrecisionStrict((double)bounds.getMin().lat()) + "\" " + "e=\"" + LatLon.roundToOsmPrecisionStrict((double)bounds.getMax().lon()) + "\" " + "n=\"" + LatLon.roundToOsmPrecisionStrict((double)bounds.getMax().lat()) + "\"");
    }

    protected String getOverpassApiRequest(String bbox) {
        return null;
    }

    protected final String oaUnion(String ... queries) {
        String result = "<union>\n";
        for (String query : queries) {
            if (query == null) continue;
            result = result + query + "\n";
        }
        result = result + "</union>";
        return result;
    }

    protected final String oaQuery(String bbox, OaQueryType type, String ... conditions) {
        String result = "<query type=\"" + (Object)((Object)type) + "\" >\n";
        if (bbox != null) {
            result = result + "<bbox-query " + bbox + "/>\n";
        }
        for (String condition : conditions) {
            if (condition == null) continue;
            result = result + condition + "\n";
        }
        result = result + "</query>";
        return result;
    }

    protected final String oaRecurse(OaRecurseType type, String into) {
        return "<recurse type=\"" + (Object)((Object)type) + "\" into=\"" + into + "\"/>\n";
    }

    protected final String oaRecurse(OaRecurseType ... types) {
        String result = "";
        for (OaRecurseType type : types) {
            result = result + "<recurse type=\"" + (Object)((Object)type) + "\"/>\n";
        }
        return result;
    }

    protected final String oaPrint() {
        return "<print mode=\"meta\"/>";
    }

    protected final String oaHasKey(String key) {
        return this.oaHasKey(key, null);
    }

    protected final String oaHasKey(String key, String value) {
        return "<has-kv k=\"" + key + "\" " + (value != null && !value.isEmpty() ? "v=\"" + value + "\"" : "") + " />";
    }

    public boolean equals(IPrimitive p1, IPrimitive p2) {
        return false;
    }

    public boolean isRelevant(IPrimitive p) {
        return false;
    }

    public final Collection<IPrimitive> extractRelevantPrimitives(DataSet ds) {
        ArrayList<IPrimitive> result = new ArrayList<IPrimitive>();
        for (OsmPrimitive p : ds.allPrimitives()) {
            if (!this.isRelevant((IPrimitive)p)) continue;
            result.add((IPrimitive)p);
        }
        return result;
    }

    public boolean isForbidden(IPrimitive p) {
        return false;
    }

    public boolean hasForbiddenTags() {
        return false;
    }

    protected final void replace(IPrimitive p, String dataKey, String osmKey) {
        this.addOrReplace(p, dataKey, osmKey, null, null, null, true);
    }

    protected final void replace(IPrimitive p, String dataKey, String osmKey, ValueReplacer replacer) {
        this.addOrReplace(p, dataKey, osmKey, null, null, replacer, true);
    }

    protected final void replace(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues) {
        this.addOrReplace(p, dataKey, osmKey, dataValues, osmValues, null, true);
    }

    protected final void add(IPrimitive p, String dataKey, String osmKey, ValueReplacer replacer) {
        this.addOrReplace(p, dataKey, osmKey, null, null, replacer, false);
    }

    protected final void add(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues) {
        this.addOrReplace(p, dataKey, osmKey, dataValues, osmValues, null, false);
    }

    private final void addOrReplace(IPrimitive p, String dataKey, String osmKey, String[] dataValues, String[] osmValues, ValueReplacer replacer, boolean replace) {
        String value = p.get(dataKey);
        if (value != null) {
            int index = -1;
            for (int i = 0; dataValues != null && index == -1 && i < dataValues.length; ++i) {
                if (!Pattern.compile(dataValues[i], 2).matcher(value).matches()) continue;
                index = i;
            }
            if (index > -1 && osmValues != null) {
                this.doAddReplace(p, dataKey, osmKey, osmValues[index], replace);
            } else if (replacer != null) {
                this.doAddReplace(p, dataKey, osmKey, replacer.replace(value), replace);
            } else if (dataValues == null || osmValues == null) {
                this.doAddReplace(p, dataKey, osmKey, value, replace);
            }
        }
    }

    private final void doAddReplace(IPrimitive p, String dataKey, String osmKey, String osmValue, boolean replace) {
        if (replace) {
            p.remove(dataKey);
        }
        p.put(osmKey, osmValue);
    }

    public String getSource() {
        return null;
    }

    public final String getSourceDate() {
        return this.sourceDate;
    }

    public final void setSourceDate(String sourceDate) {
        this.sourceDate = sourceDate;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public String getLocalPortalIconName() {
        return "o24.png";
    }

    public String getNationalPortalIconName() {
        return "o24.png";
    }

    public String getDataLayerIconName() {
        return "o16.png";
    }

    public boolean handlesSpreadSheetProjection() {
        return false;
    }

    public List<Projection> getSpreadSheetProjections() {
        return null;
    }

    public LatLon getSpreadSheetCoor(EastNorth en, String[] fields) {
        return null;
    }

    public Charset getCsvCharset() {
        return null;
    }

    public String getCsvSeparator() {
        return null;
    }

    public int getSheetNumber() {
        return -1;
    }

    public SourceEditor.ExtendedSourceEntry getMapPaintStyle() {
        return null;
    }

    public SourceEditor.ExtendedSourceEntry getTaggingPreset() {
        return null;
    }

    protected final SourceEditor.ExtendedSourceEntry getMapPaintStyle(String displayName) {
        return this.getMapPaintStyle(displayName, this.getClass().getSimpleName().replace("Handler", ""));
    }

    protected final SourceEditor.ExtendedSourceEntry getMapPaintStyle(String displayName, String fileNameWithoutExtension) {
        return new SourceEditor.ExtendedSourceEntry(displayName, "resource://" + this.getClass().getPackage().getName().replace(".", "/") + "/" + fileNameWithoutExtension + "." + "mapcss");
    }

    public boolean preferMultipolygonToSimpleWay() {
        return false;
    }

    public final void setAssociatedFile(File associatedFile) {
        this.associatedFile = associatedFile;
    }

    public final File getAssociatedFile() {
        return this.associatedFile;
    }

    private static final Double get(ParameterValueGroup values, ParameterDescriptor desc) {
        return (Double)values.parameter(desc.getName().getCode()).getValue();
    }

    private static final boolean equals(Double a, Double b) {
        boolean res;
        boolean bl = res = Math.abs(a - b) <= Main.pref.getDouble("opendata.crs.comparison_tolerance", DEFAULT_CRS_COMPARISON_TOLERANCE.doubleValue());
        if (Main.pref.getBoolean("opendata.crs.comparison_debug", false)) {
            System.out.println("Comparing " + a + " and " + b + " -> " + res);
        }
        return res;
    }

    public MathTransform findMathTransform(CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS, boolean lenient) throws FactoryException {
        if (sourceCRS instanceof AbstractDerivedCRS && sourceCRS.getName().getCode().equalsIgnoreCase("Lambert_Conformal_Conic")) {
            ArrayList<MathTransform> result = new ArrayList<MathTransform>();
            AbstractDerivedCRS crs = (AbstractDerivedCRS)sourceCRS;
            MathTransform transform = crs.getConversionFromBase().getMathTransform();
            if (transform instanceof LambertConformal && crs.getDatum() instanceof GeodeticDatum) {
                LambertConformal lambert = (LambertConformal)transform;
                GeodeticDatum geo = (GeodeticDatum)crs.getDatum();
                for (Projection p : Projections.getProjections()) {
                    AbstractProjection ap;
                    if (!(p instanceof AbstractProjection) || !((ap = (AbstractProjection)p).getProj() instanceof LambertConformalConic)) continue;
                    for (Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid> pair : ellipsoids) {
                        if (!((Ellipsoid)pair.a).equals(geo.getEllipsoid()) || !((org.openstreetmap.josm.data.projection.Ellipsoid)pair.b).equals(ap.getEllipsoid())) continue;
                        boolean ok = true;
                        ParameterValueGroup values = lambert.getParameterValues();
                        LambertConformalConic.Parameters params = ((LambertConformalConic)ap.getProj()).getParameters();
                        ok = ok ? AbstractDataSetHandler.equals(AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN), params.latitudeOrigin) : ok;
                        ok = ok ? AbstractDataSetHandler.equals(AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.CENTRAL_MERIDIAN), ap.getCentralMeridian()) : ok;
                        ok = ok ? AbstractDataSetHandler.equals(AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.SCALE_FACTOR), ap.getScaleFactor()) : ok;
                        ok = ok ? AbstractDataSetHandler.equals(AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.FALSE_EASTING), ap.getFalseEasting()) : ok;
                        boolean bl = ok = ok ? AbstractDataSetHandler.equals(AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.FALSE_NORTHING), ap.getFalseNorthing()) : ok;
                        if (lambert instanceof LambertConformal2SP && params instanceof LambertConformalConic.Parameters2SP) {
                            LambertConformalConic.Parameters2SP param = (LambertConformalConic.Parameters2SP)params;
                            ok = ok ? AbstractDataSetHandler.equals(Math.min(AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_1), AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_2)), Math.min(param.standardParallel1, param.standardParallel2)) : ok;
                            ok = ok ? AbstractDataSetHandler.equals(Math.max(AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_1), AbstractDataSetHandler.get(values, MapProjection.AbstractProvider.STANDARD_PARALLEL_2)), Math.max(param.standardParallel1, param.standardParallel2)) : ok;
                        } else if (!(lambert instanceof LambertConformal1SP) || !(params instanceof LambertConformalConic.Parameters1SP)) {
                            ok = false;
                        }
                        if (!ok) continue;
                        try {
                            result.add(CRS.findMathTransform(CRS.decode(p.toCode()), targetCRS, lenient));
                        }
                        catch (FactoryException e) {
                            System.err.println(e.getMessage());
                        }
                    }
                }
            }
            if (!result.isEmpty()) {
                if (result.size() > 1) {
                    System.err.println("Found multiple projections !");
                }
                return (MathTransform)result.get(0);
            }
        }
        return null;
    }

    public boolean checkShpNodeProximity() {
        return false;
    }

    public boolean acceptsUrl(String url) {
        if (this.getDataURL() != null && url.equals(this.getDataURL().toString())) {
            return true;
        }
        if (this.getDataURLs() != null) {
            for (Pair<String, URL> pair : this.getDataURLs()) {
                if (pair.b == null || !url.equals(((URL)pair.b).toString())) continue;
                return true;
            }
        }
        return false;
    }

    static {
        ellipsoids.add((Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>)new Pair((Object)DefaultEllipsoid.GRS80, (Object)org.openstreetmap.josm.data.projection.Ellipsoid.GRS80));
        ellipsoids.add((Pair<Ellipsoid, org.openstreetmap.josm.data.projection.Ellipsoid>)new Pair((Object)DefaultEllipsoid.WGS84, (Object)org.openstreetmap.josm.data.projection.Ellipsoid.WGS84));
    }

    public static interface ValueReplacer {
        public String replace(String var1);
    }

    public static enum OaRecurseType {
        RELATION_RELATION("relation-relation"),
        RELATION_BACKWARDS("relation-backwards"),
        RELATION_WAY("relation-way"),
        RELATION_NODE("relation-node"),
        WAY_NODE("way-node"),
        WAY_RELATION("way-relation"),
        NODE_RELATION("node-relation"),
        NODE_WAY("node-way");

        private final String value;

        public String toString() {
            return this.value;
        }

        private OaRecurseType(String value) {
            this.value = value;
        }
    }

    public static enum OaQueryType {
        NODE("node"),
        WAY("way"),
        RELATION("relation");

        private final String value;

        public String toString() {
            return this.value;
        }

        private OaQueryType(String value) {
            this.value = value;
        }
    }
}

