/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.factory.Hints;
import org.geotools.metadata.iso.citation.CitationImpl;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.PropertyAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Loggings;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;

public class FactoryUsingWKT
extends DeferredAuthorityFactory
implements CRSAuthorityFactory {
    private Citation authority;
    public static final String FILENAME = "epsg.properties";
    private final ReferencingFactoryContainer factories;
    protected static final int DEFAULT_PRIORITY = 80;
    private final File directory;

    public FactoryUsingWKT() {
        this(null);
    }

    public FactoryUsingWKT(Hints userHints) {
        this(userHints, 80);
    }

    protected FactoryUsingWKT(Hints userHints, int priority) {
        super(userHints, priority);
        this.factories = ReferencingFactoryContainer.instance(userHints);
        Object hint = null;
        if (userHints != null) {
            hint = userHints.get(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        }
        this.directory = hint instanceof File ? (File)hint : (hint instanceof String ? new File((String)hint) : null);
        this.hints.put(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, this.directory);
        this.setTimeout(900000L);
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            Citation[] authorities = this.getAuthorities();
            switch (authorities.length) {
                case 0: {
                    this.authority = Citations.EPSG;
                    break;
                }
                case 1: {
                    this.authority = authorities[0];
                    break;
                }
                default: {
                    CitationImpl c = new CitationImpl(authorities[0]);
                    Collection<Identifier> identifiers = c.getIdentifiers();
                    for (int i = 1; i < authorities.length; ++i) {
                        identifiers.addAll(authorities[i].getIdentifiers());
                    }
                    c.freeze();
                    this.authority = c;
                    break;
                }
            }
        }
        return this.authority;
    }

    protected Citation[] getAuthorities() {
        return new Citation[]{Citations.EPSG};
    }

    protected URL getDefinitionsURL() {
        try {
            File file;
            if (this.directory != null && (file = new File(this.directory, FILENAME)).isFile()) {
                return file.toURI().toURL();
            }
        }
        catch (SecurityException exception) {
            Logging.unexpectedException(LOGGER, exception);
        }
        catch (MalformedURLException exception) {
            Logging.unexpectedException(LOGGER, exception);
        }
        return FactoryUsingWKT.class.getResource(FILENAME);
    }

    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        try {
            URL url = this.getDefinitionsURL();
            if (url == null) {
                throw new FactoryNotFoundException(Errors.format(50, FILENAME));
            }
            Iterator<? extends Identifier> ids = this.getAuthority().getIdentifiers().iterator();
            String authority = ids.hasNext() ? ids.next().getCode() : "EPSG";
            LogRecord record = Loggings.format(Level.CONFIG, 49, url.getPath(), authority);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
            return new PropertyAuthorityFactory(this.factories, this.getAuthorities(), url);
        }
        catch (IOException exception) {
            throw new FactoryException(Errors.format(28, FILENAME), exception);
        }
    }
}

