/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter;

import java.awt.Color;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class Filters {
    public Filters() {
        this(CommonFactoryFinder.getFilterFactory2(null));
    }

    public Filters(FilterFactory2 factory) {
    }

    public static double number(Object value) {
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            return number.doubleValue();
        }
        if (value instanceof String) {
            String text = (String)value;
            try {
                Number number = (Number)Filters.gets(text, Number.class);
                return number.doubleValue();
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Unable to decode '" + text + "' as a number");
            }
        }
        if (value instanceof Expression) {
            throw new IllegalArgumentException("Cannot deal with un evaulated Expression");
        }
        throw new IllegalArgumentException("Unable to evaulate " + value.getClass() + " in a numeric context");
    }

    public static Object gets(String text, Class TYPE) throws Throwable {
        if (text == null) {
            return null;
        }
        if (TYPE == String.class) {
            return text;
        }
        if (TYPE == Integer.class) {
            return Integer.decode(text);
        }
        if (TYPE == Double.class) {
            return Double.valueOf(text);
        }
        if (TYPE == Number.class) {
            try {
                return Double.valueOf(text);
            }
            catch (NumberFormatException ignore) {
                return Integer.decode(text);
            }
        }
        if (TYPE == Color.class) {
            return new Color(Integer.decode(text));
        }
        try {
            Constructor create = TYPE.getConstructor(String.class);
            return create.newInstance(text);
        }
        catch (SecurityException e) {
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return null;
    }
}

