/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.AbstractDataStore;
import org.geotools.data.DefaultQuery;
import org.geotools.data.Diff;
import org.geotools.data.DiffFeatureWriter;
import org.geotools.data.FeatureWriter;
import org.geotools.data.FilteringFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.GeometryAttribute;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;

public class TransactionStateDiff
implements Transaction.State {
    AbstractDataStore store;
    Transaction transaction;
    Map typeNameDiff = new HashMap();
    public static final SimpleFeature NULL = new SimpleFeature(){

        @Override
        public Object getAttribute(String path) {
            return null;
        }

        @Override
        public Object getAttribute(int index) {
            return null;
        }

        @Override
        public ReferencedEnvelope getBounds() {
            return null;
        }

        @Override
        public Geometry getDefaultGeometry() {
            return null;
        }

        @Override
        public SimpleFeatureType getFeatureType() {
            return null;
        }

        @Override
        public String getID() {
            return null;
        }

        @Override
        public FeatureId getIdentifier() {
            return null;
        }

        @Override
        public void setAttribute(int position, Object val) {
        }

        @Override
        public void setAttribute(String path, Object attribute) throws IllegalAttributeException {
        }

        @Override
        public Object getAttribute(Name name) {
            return null;
        }

        @Override
        public List<Object> getAttributes() {
            return null;
        }

        @Override
        public SimpleFeatureType getType() {
            return null;
        }

        @Override
        public void setAttribute(Name name, Object value) {
        }

        @Override
        public void setAttributes(List<Object> values) {
        }

        @Override
        public GeometryAttribute getDefaultGeometryProperty() {
            return null;
        }

        @Override
        public Collection<Property> getProperties() {
            return null;
        }

        @Override
        public Property getProperty(Name name) {
            return null;
        }

        @Override
        public Property getProperty(String name) {
            return null;
        }

        @Override
        public Collection<? extends Property> getValue() {
            return null;
        }

        @Override
        public AttributeDescriptor getDescriptor() {
            return null;
        }

        @Override
        public Name getName() {
            return null;
        }

        @Override
        public Map<Object, Object> getUserData() {
            return null;
        }

        @Override
        public boolean isNillable() {
            return false;
        }

        public String toString() {
            return "<NullFeature>";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object arg0) {
            return arg0 == this;
        }

        @Override
        public void validate() {
        }
    };

    public TransactionStateDiff(AbstractDataStore dataStore) {
        this.store = dataStore;
    }

    public synchronized Diff diff(String typeName) throws IOException {
        if (!this.exists(typeName)) {
            throw new IOException(typeName + " not defined");
        }
        if (this.typeNameDiff.containsKey(typeName)) {
            return (Diff)this.typeNameDiff.get(typeName);
        }
        Diff diff = new Diff();
        this.typeNameDiff.put(typeName, diff);
        return diff;
    }

    boolean exists(String typeName) {
        Object[] types;
        try {
            types = this.store.getTypeNames();
        }
        catch (IOException e) {
            return false;
        }
        Arrays.sort(types);
        return Arrays.binarySearch(types, typeName) != -1;
    }

    public synchronized FeatureWriter<SimpleFeatureType, SimpleFeature> writer(final String typeName, Filter filter) throws IOException {
        Diff diff = this.diff(typeName);
        FilteringFeatureReader<SimpleFeatureType, SimpleFeature> reader = new FilteringFeatureReader<SimpleFeatureType, SimpleFeature>(this.store.getFeatureReader(typeName, new DefaultQuery(typeName, filter)), filter);
        return new DiffFeatureWriter(reader, diff, filter){

            @Override
            public void fireNotification(int eventType, ReferencedEnvelope bounds) {
                switch (eventType) {
                    case 1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesAdded(typeName, TransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case 0: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesChanged(typeName, TransactionStateDiff.this.transaction, bounds, false);
                        break;
                    }
                    case -1: {
                        TransactionStateDiff.this.store.listenerManager.fireFeaturesRemoved(typeName, TransactionStateDiff.this.transaction, bounds, false);
                    }
                }
            }

            public String toString() {
                return "<DiffFeatureWriter>(" + this.reader.toString() + ")";
            }
        };
    }
}

