/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.Set;
import org.geotools.data.AbstractFeatureStore;
import org.geotools.data.DataSourceException;
import org.geotools.data.DefaultQuery;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockException;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public abstract class AbstractFeatureLocking
extends AbstractFeatureStore
implements SimpleFeatureLocking {
    FeatureLock featureLock = FeatureLock.TRANSACTION;

    public AbstractFeatureLocking() {
    }

    public AbstractFeatureLocking(Set hints) {
        super(hints);
    }

    @Override
    public void setFeatureLock(FeatureLock lock) {
        if (lock == null) {
            throw new NullPointerException("A FeatureLock is required - did you mean FeatureLock.TRANSACTION?");
        }
        this.featureLock = lock;
    }

    @Override
    public int lockFeatures() throws IOException {
        return this.lockFeatures(Filter.INCLUDE);
    }

    @Override
    public int lockFeatures(Filter filter) throws IOException {
        return this.lockFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int lockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        SimpleFeatureIterator reader = this.getFeatures(query).features();
        String typeName = query.getTypeName();
        int count = 0;
        try {
            while (reader.hasNext()) {
                try {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    lockingManager.lockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                    ++count;
                }
                catch (FeatureLockException locked) {
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", nosuch);
                    return count;
                }
            }
        }
        finally {
            reader.close();
        }
    }

    @Override
    public void unLockFeatures() throws IOException {
        this.unLockFeatures(Filter.INCLUDE);
    }

    @Override
    public void unLockFeatures(Filter filter) throws IOException {
        this.unLockFeatures(new DefaultQuery(((SimpleFeatureType)this.getSchema()).getTypeName(), filter));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void unLockFeatures(Query query) throws IOException {
        LockingManager lockingManager = this.getDataStore().getLockingManager();
        if (lockingManager == null) {
            throw new UnsupportedOperationException("DataStore not using lockingManager, must provide alternate implementation");
        }
        SimpleFeatureIterator reader = this.getFeatures(query).features();
        String typeName = query.getTypeName();
        try {
            while (reader.hasNext()) {
                try {
                    SimpleFeature feature = (SimpleFeature)reader.next();
                    lockingManager.unLockFeatureID(typeName, feature.getID(), this.getTransaction(), this.featureLock);
                }
                catch (NoSuchElementException nosuch) {
                    throw new DataSourceException("Problem with " + query.getHandle() + " while locking", nosuch);
                    return;
                }
            }
        }
        finally {
            reader.close();
        }
    }
}

