/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Duration;
import javax.measure.unit.SI;
import javax.measure.unit.SystemOfUnits;
import javax.measure.unit.Unit;

public final class NonSI
extends SystemOfUnits {
    private static HashSet<Unit<?>> UNITS = new HashSet();
    public static final Unit<Duration> MINUTE = NonSI.nonSI(SI.SECOND.times(60L));
    public static final Unit<Duration> HOUR = NonSI.nonSI(MINUTE.times(60L));
    public static final Unit<Duration> DAY = NonSI.nonSI(HOUR.times(24L));
    public static final Unit<Angle> REVOLUTION = NonSI.nonSI(SI.RADIAN.times(Math.PI * 2));
    public static final Unit<Angle> DEGREE_ANGLE = NonSI.nonSI(REVOLUTION.divide(360L));
    public static final Unit<Angle> MINUTE_ANGLE = NonSI.nonSI(DEGREE_ANGLE.divide(60L));
    public static final Unit<Angle> SECOND_ANGLE = NonSI.nonSI(MINUTE_ANGLE.divide(60L));

    private NonSI() {
    }

    @Override
    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(UNITS);
    }

    private static <U extends Unit<?>> U nonSI(U u) {
        UNITS.add(u);
        return u;
    }
}

