/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.operation.overlay.snap;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.overlay.OverlayOp;
import com.vividsolutions.jts.operation.overlay.snap.GeometrySnapper;
import com.vividsolutions.jts.precision.CommonBitsRemover;

public class SnapOverlayOp {
    private Geometry[] geom = new Geometry[2];
    private double snapTolerance;
    private CommonBitsRemover cbr;

    public static Geometry overlayOp(Geometry geometry, Geometry geometry2, int n) {
        SnapOverlayOp snapOverlayOp = new SnapOverlayOp(geometry, geometry2);
        return snapOverlayOp.getResultGeometry(n);
    }

    public SnapOverlayOp(Geometry geometry, Geometry geometry2) {
        this.geom[0] = geometry;
        this.geom[1] = geometry2;
        this.computeSnapTolerance();
    }

    private void computeSnapTolerance() {
        this.snapTolerance = GeometrySnapper.computeOverlaySnapTolerance(this.geom[0], this.geom[1]);
    }

    public Geometry getResultGeometry(int n) {
        Geometry[] geometryArray = this.snap(this.geom);
        Geometry geometry = OverlayOp.overlayOp(geometryArray[0], geometryArray[1], n);
        return this.prepareResult(geometry);
    }

    private Geometry[] snap(Geometry[] geometryArray) {
        Geometry[] geometryArray2 = this.removeCommonBits(geometryArray);
        Geometry[] geometryArray3 = GeometrySnapper.snap(geometryArray2[0], geometryArray2[1], this.snapTolerance);
        return geometryArray3;
    }

    private Geometry prepareResult(Geometry geometry) {
        this.cbr.addCommonBits(geometry);
        return geometry;
    }

    private Geometry[] removeCommonBits(Geometry[] geometryArray) {
        this.cbr = new CommonBitsRemover();
        this.cbr.add(geometryArray[0]);
        this.cbr.add(geometryArray[1]);
        Geometry[] geometryArray2 = new Geometry[]{this.cbr.removeCommonBits((Geometry)geometryArray[0].clone()), this.cbr.removeCommonBits((Geometry)geometryArray[1].clone())};
        return geometryArray2;
    }
}

