/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.util;

import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;

public class GeometryTransformer {
    protected GeometryFactory factory = null;
    private boolean pruneEmptyGeometry = true;
    private boolean preserveGeometryCollectionType = true;
    private boolean preserveType = false;

    public final Geometry transform(Geometry geometry) {
        this.factory = geometry.getFactory();
        if (geometry instanceof Point) {
            return this.transformPoint((Point)geometry);
        }
        if (geometry instanceof MultiPoint) {
            return this.transformMultiPoint((MultiPoint)geometry);
        }
        if (geometry instanceof LinearRing) {
            return this.transformLinearRing((LinearRing)geometry);
        }
        if (geometry instanceof LineString) {
            return this.transformLineString((LineString)geometry);
        }
        if (geometry instanceof MultiLineString) {
            return this.transformMultiLineString((MultiLineString)geometry);
        }
        if (geometry instanceof Polygon) {
            return this.transformPolygon((Polygon)geometry);
        }
        if (geometry instanceof MultiPolygon) {
            return this.transformMultiPolygon((MultiPolygon)geometry);
        }
        if (geometry instanceof GeometryCollection) {
            return this.transformGeometryCollection((GeometryCollection)geometry);
        }
        throw new IllegalArgumentException("Unknown Geometry subtype: " + geometry.getClass().getName());
    }

    protected final CoordinateSequence copy(CoordinateSequence coordinateSequence) {
        return (CoordinateSequence)coordinateSequence.clone();
    }

    protected CoordinateSequence transformCoordinates(CoordinateSequence coordinateSequence) {
        return this.copy(coordinateSequence);
    }

    protected Geometry transformPoint(Point point) {
        return this.factory.createPoint(this.transformCoordinates(point.getCoordinateSequence()));
    }

    protected Geometry transformMultiPoint(MultiPoint multiPoint) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < multiPoint.getNumGeometries(); ++i) {
            Geometry geometry = this.transformPoint((Point)multiPoint.getGeometryN(i));
            if (geometry == null || geometry.isEmpty()) continue;
            arrayList.add(geometry);
        }
        return this.factory.buildGeometry(arrayList);
    }

    protected Geometry transformLinearRing(LinearRing linearRing) {
        CoordinateSequence coordinateSequence = this.transformCoordinates(linearRing.getCoordinateSequence());
        int n = coordinateSequence.size();
        if (n > 0 && n < 4 && !this.preserveType) {
            return this.factory.createLineString(coordinateSequence);
        }
        return this.factory.createLinearRing(coordinateSequence);
    }

    protected Geometry transformLineString(LineString lineString) {
        return this.factory.createLineString(this.transformCoordinates(lineString.getCoordinateSequence()));
    }

    protected Geometry transformMultiLineString(MultiLineString multiLineString) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < multiLineString.getNumGeometries(); ++i) {
            Geometry geometry = this.transformLineString((LineString)multiLineString.getGeometryN(i));
            if (geometry == null || geometry.isEmpty()) continue;
            arrayList.add(geometry);
        }
        return this.factory.buildGeometry(arrayList);
    }

    protected Geometry transformPolygon(Polygon polygon) {
        boolean bl = true;
        Geometry geometry = this.transformLinearRing((LinearRing)polygon.getExteriorRing());
        if (geometry == null || !(geometry instanceof LinearRing) || geometry.isEmpty()) {
            bl = false;
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            Geometry geometry2 = this.transformLinearRing((LinearRing)polygon.getInteriorRingN(i));
            if (geometry2 == null || geometry2.isEmpty()) continue;
            if (!(geometry2 instanceof LinearRing)) {
                bl = false;
            }
            arrayList.add(geometry2);
        }
        if (bl) {
            return this.factory.createPolygon((LinearRing)geometry, arrayList.toArray(new LinearRing[0]));
        }
        ArrayList<Geometry> arrayList2 = new ArrayList<Geometry>();
        if (geometry != null) {
            arrayList2.add(geometry);
        }
        arrayList2.addAll(arrayList);
        return this.factory.buildGeometry(arrayList2);
    }

    protected Geometry transformMultiPolygon(MultiPolygon multiPolygon) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < multiPolygon.getNumGeometries(); ++i) {
            Geometry geometry = this.transformPolygon((Polygon)multiPolygon.getGeometryN(i));
            if (geometry == null || geometry.isEmpty()) continue;
            arrayList.add(geometry);
        }
        return this.factory.buildGeometry(arrayList);
    }

    protected Geometry transformGeometryCollection(GeometryCollection geometryCollection) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
            Geometry geometry = this.transform(geometryCollection.getGeometryN(i));
            if (geometry == null || this.pruneEmptyGeometry && geometry.isEmpty()) continue;
            arrayList.add(geometry);
        }
        if (this.preserveGeometryCollectionType) {
            return this.factory.createGeometryCollection(GeometryFactory.toGeometryArray(arrayList));
        }
        return this.factory.buildGeometry(arrayList);
    }
}

