/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import java.util.ArrayList;

public class MultiPolygon
extends GeometryCollection
implements Polygonal {
    private static final long serialVersionUID = -551033529766975875L;

    public MultiPolygon(Polygon[] polygonArray, GeometryFactory geometryFactory) {
        super(polygonArray, geometryFactory);
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getBoundaryDimension() {
        return 1;
    }

    @Override
    public String getGeometryType() {
        return "MultiPolygon";
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public Geometry getBoundary() {
        if (this.isEmpty()) {
            return this.getFactory().createMultiLineString(null);
        }
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (int i = 0; i < this.geometries.length; ++i) {
            Polygon polygon = (Polygon)this.geometries[i];
            Geometry geometry = polygon.getBoundary();
            for (int j = 0; j < geometry.getNumGeometries(); ++j) {
                arrayList.add(geometry.getGeometryN(j));
            }
        }
        LineString[] lineStringArray = new LineString[arrayList.size()];
        return this.getFactory().createMultiLineString(arrayList.toArray(lineStringArray));
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        return super.equalsExact(geometry, d);
    }

    @Override
    public Geometry reverse() {
        int n = this.geometries.length;
        Polygon[] polygonArray = new Polygon[n];
        for (int i = 0; i < this.geometries.length; ++i) {
            polygonArray[i] = (Polygon)this.geometries[i].reverse();
        }
        return this.getFactory().createMultiPolygon(polygonArray);
    }
}

