/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.education;

import java.nio.charset.Charset;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;

public class Etab1er2ndDegreHandler
extends DataGouvDataSetHandler {
    public Etab1er2ndDegreHandler() {
        super("G\u00e9olocalisation-des-\u00e9tablissements-d'enseignement-du-premier-degr\u00e9-et-du-second-degr\u00e9-du-minist\u00e8re-d-30378093");
        this.setName("\u00c9tablissements d'enseignement du premier degr\u00e9 et du second degr\u00e9");
        this.setDataGouvFrUrl("MENJVA_etab_geoloc.csv");
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsCsvFilename(filename, new String[]{"MENJVA_etab_geoloc(\\.csv-fr)?"});
    }

    public void updateDataSet(DataSet ds) {
        for (Node n : ds.getNodes()) {
            n.put("amenity", "school");
            this.replace((IPrimitive)n, "numero_uai", "ref:FR:UAI");
            this.replace((IPrimitive)n, "appellation_officielle_uai", "name");
            this.add((IPrimitive)n, "lib_nature", "school:FR", new String[]{".*MATERNELLE.*", ".*ELEMENTAIRE.*", "COLLEGE.*", "LYCEE.*"}, new String[]{"maternelle", "\u00e9l\u00e9mentaire", "college", "lyc\u00e9e"});
            n.remove("etat_etablissement");
            n.remove("nature_uai");
            n.remove("patronyme_uai");
            n.remove("sous_fic");
        }
    }

    public boolean handlesSpreadSheetProjection() {
        return true;
    }

    public LatLon getSpreadSheetCoor(EastNorth en, String[] fields) {
        return Etab1er2ndDegreHandler.getLatLonByDptCode((EastNorth)en, (String)fields[0].substring(0, 3), (boolean)false);
    }

    public Charset getCsvCharset() {
        return Charset.forName("ISO-8859-15");
    }
}

