/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.agriculture;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.preferences.SourceEditor;
import org.openstreetmap.josm.plugins.opendata.core.datasets.fr.FrenchDepartment;
import org.openstreetmap.josm.plugins.opendata.modules.fr.datagouvfr.datasets.DataGouvDataSetHandler;
import org.openstreetmap.josm.tools.Pair;

public class RegistreParcellaireHandler
extends DataGouvDataSetHandler {
    protected static final int PAS_D_INFORMATION = 0;
    protected static final int BLE_TENDRE = 1;
    protected static final int MAIS_GRAIN_ET_ENSILAGE = 2;
    protected static final int ORGE = 3;
    protected static final int AUTRES_CEREALES = 4;
    protected static final int COLZA = 5;
    protected static final int TOURNESOL = 6;
    protected static final int AUTRES_OLEAGINEUX = 7;
    protected static final int PROTEAGINEUX = 8;
    protected static final int PLANTES_A_FIBRES = 9;
    protected static final int SEMENCES = 10;
    protected static final int GEL_SURFACES_GELEES_SANS_PRODUCTION = 11;
    protected static final int GEL_INDUSTRIEL = 12;
    protected static final int AUTRES_GELS = 13;
    protected static final int RIZ = 14;
    protected static final int LEGUMINEUSES_A_GRAINS = 15;
    protected static final int FOURRAGE = 16;
    protected static final int ESTIVES_LANDES = 17;
    protected static final int PRAIRIES_PERMANENTES = 18;
    protected static final int PRAIRIES_TEMPORAIRES = 19;
    protected static final int VERGERS = 20;
    protected static final int VIGNES = 21;
    protected static final int FRUITS_A_COQUE = 22;
    protected static final int OLIVIERS = 23;
    protected static final int AUTRES_CULTURES_INDUSTRIELLES = 24;
    protected static final int LEGUMES_FLEURS = 25;
    protected static final int CANNE_A_SUCRE = 26;
    protected static final int ARBORICULTURE = 27;
    protected static final int DIVERS = 28;

    public RegistreParcellaireHandler() {
        this.setName("Registre Parcellaire Graphique");
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsShpFilename(filename, new String[]{"RPG_20.._..."});
    }

    public SourceEditor.ExtendedSourceEntry getMapPaintStyle() {
        return this.getMapPaintStyle("Registre Parcellaire Graphique (France)");
    }

    public void updateDataSet(DataSet ds) {
        block7: for (OsmPrimitive p : ds.allPrimitives()) {
            String code = p.get("CULT_MAJ");
            if (code == null || code.isEmpty()) continue;
            this.replace((IPrimitive)p, "NUM_ILOT", "ref:FR:RPG");
            this.replace((IPrimitive)p, "CULT_MAJ", "code:FR:RPG");
            switch (Integer.parseInt(code)) {
                case 27: {
                    p.put("landuse", "forest");
                    continue block7;
                }
                case 11: 
                case 12: 
                case 13: 
                case 16: 
                case 17: 
                case 18: 
                case 19: {
                    p.put("landuse", "meadow");
                    continue block7;
                }
                case 23: {
                    p.put("trees", "olive_tree");
                }
                case 20: {
                    p.put("landuse", "orchard");
                    continue block7;
                }
                case 21: {
                    p.put("landuse", "vineyard");
                    continue block7;
                }
            }
            p.put("landuse", "farm");
        }
    }

    private Pair<String, URL> getRpgURL(String number, String name) throws MalformedURLException {
        return new Pair((Object)(number + " - " + name), (Object)new URL("http://www.data.gouv.fr/var/download/ign/RPG_2010_" + number + ".ZIP"));
    }

    public List<Pair<String, URL>> getDataURLs() {
        ArrayList<Pair<String, URL>> result = new ArrayList<Pair<String, URL>>();
        try {
            for (FrenchDepartment dpt : FrenchDepartment.allDepartments) {
                result.add(this.getRpgURL(dpt.getCode(), dpt.getName()));
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return result;
    }
}

