/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.transport;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.plugins.opendata.core.io.NeptuneReader;
import org.openstreetmap.josm.plugins.opendata.modules.fr.toulouse.datasets.ToulouseDataSetHandler;

public class ReseauTisseoHandler
extends ToulouseDataSetHandler {
    private static final URL neptuneSchemaUrl = ReseauTisseoHandler.class.getResource("/neptune_toulouse/neptune.xsd");

    public ReseauTisseoHandler() {
        super(14022, "network=fr_tisseo");
        NeptuneReader.registerSchema((URL)neptuneSchemaUrl);
        this.setName("R\u00e9seau Tiss\u00e9o (M\u00e9tro, Bus, Tram)");
        this.setCategory(CAT_TRANSPORT);
    }

    public boolean acceptsFilename(String filename) {
        return this.acceptsZipFilename(filename, new String[]{"14022-reseau-tisseo-metro-bus-tram-"}) || filename.toLowerCase().endsWith("xml");
    }

    public boolean acceptsFile(File file) {
        return this.acceptsFilename(file.getName()) && (file.getName().toLowerCase().endsWith("zip") || NeptuneReader.acceptsXmlNeptuneFile((File)file, (URL)neptuneSchemaUrl));
    }

    @Override
    public String getSource() {
        return "Tiss\u00e9o SMTC";
    }

    @Override
    public URL getWikiURL() {
        try {
            return new URL("http://wiki.openstreetmap.org/wiki/Toulouse/Transports_en_commun#R\u00e9seau_Tiss\u00e9o");
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void updateDataSet(DataSet ds) {
        for (OsmPrimitive p : ds.allPrimitives()) {
            p.put("operator", "Tiss\u00e9o");
            p.put("network", "fr_tisseo");
        }
    }
}

