/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry;

import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.MergeNodesAction;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.MoveCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.RelationToChildReference;
import org.openstreetmap.josm.data.osm.TagCollection;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.DefaultNameFormatter;
import org.openstreetmap.josm.gui.conflict.tags.CombinePrimitiveResolverDialog;
import org.openstreetmap.josm.gui.conflict.tags.TagConflictResolutionUtil;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.plugins.utilsplugin2.replacegeometry.HungarianAlgorithm;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReplaceGeometryUtils {
    private static final String TITLE = I18n.tr((String)"Replace Geometry", (Object[])new Object[0]);

    public static boolean replaceWithNew(OsmPrimitive firstObject, OsmPrimitive secondObject) {
        if (firstObject instanceof Node && secondObject instanceof Node) {
            return ReplaceGeometryUtils.replaceNodeWithNew((Node)firstObject, (Node)secondObject);
        }
        if (firstObject instanceof Way && secondObject instanceof Way) {
            return ReplaceGeometryUtils.replaceWayWithNew(Arrays.asList((Way)firstObject, (Way)secondObject));
        }
        if (firstObject instanceof Node) {
            return ReplaceGeometryUtils.upgradeNode((Node)firstObject, secondObject);
        }
        if (secondObject instanceof Node) {
            return ReplaceGeometryUtils.upgradeNode((Node)secondObject, firstObject);
        }
        throw new IllegalArgumentException(I18n.tr((String)"This tool can only replace a node, upgrade a node to a way or a multipolygon, or replace a way with a way.", (Object[])new Object[0]));
    }

    public static boolean replace(OsmPrimitive subjectObject, OsmPrimitive referenceSubject) {
        if (subjectObject instanceof Node && referenceSubject instanceof Node) {
            return ReplaceGeometryUtils.replaceNode((Node)subjectObject, (Node)referenceSubject);
        }
        if (subjectObject instanceof Way && referenceSubject instanceof Way) {
            return ReplaceGeometryUtils.replaceWay((Way)subjectObject, (Way)referenceSubject);
        }
        if (subjectObject instanceof Node) {
            return ReplaceGeometryUtils.upgradeNode((Node)subjectObject, referenceSubject);
        }
        if (referenceSubject instanceof Node) {
            return ReplaceGeometryUtils.upgradeNode((Node)referenceSubject, subjectObject);
        }
        throw new IllegalArgumentException(I18n.tr((String)"This tool can only replace a node, upgrade a node to a way or a multipolygon, or replace a way with a way.", (Object[])new Object[0]));
    }

    public static boolean replaceNodeWithNew(Node firstNode, Node secondNode) {
        if (firstNode.isNew() && !secondNode.isNew()) {
            return ReplaceGeometryUtils.replaceNode(secondNode, firstNode);
        }
        if (!firstNode.isNew() && secondNode.isNew()) {
            return ReplaceGeometryUtils.replaceNode(firstNode, secondNode);
        }
        return ReplaceGeometryUtils.replaceNode(firstNode, secondNode);
    }

    public static boolean replaceNode(Node subjectNode, Node referenceNode) {
        if (!OsmPrimitive.getFilteredList((Collection)subjectNode.getReferrers(), Way.class).isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Node belongs to way(s), cannot replace.", (Object[])new Object[0]), TITLE, 1);
            return false;
        }
        ArrayList<Command> commands = new ArrayList<Command>();
        commands.add(MergeNodesAction.mergeNodes((OsmDataLayer)Main.main.getEditLayer(), Arrays.asList(subjectNode, referenceNode), (Node)referenceNode));
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry for node {0}", (Object[])new Object[]{subjectNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
        return true;
    }

    public static boolean upgradeNode(Node subjectNode, OsmPrimitive referenceObject) {
        if (!OsmPrimitive.getFilteredList((Collection)subjectNode.getReferrers(), Way.class).isEmpty()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Node belongs to way(s), cannot replace.", (Object[])new Object[0]), TITLE, 1);
            return false;
        }
        if (referenceObject instanceof Relation && !((Relation)referenceObject).isMultipolygon()) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Relation is not a multipolygon, cannot be used as a replacement.", (Object[])new Object[0]), TITLE, 1);
            return false;
        }
        Node nodeToReplace = null;
        if (!subjectNode.isNew()) {
            HashSet<Node> nodePool = new HashSet<Node>();
            if (referenceObject instanceof Way) {
                nodePool.addAll(ReplaceGeometryUtils.getUnimportantNodes((Way)referenceObject));
            } else if (referenceObject instanceof Relation) {
                for (RelationMember member : ((Relation)referenceObject).getMembers()) {
                    if (!member.getRole().equals("outer") && !member.getRole().equals("inner") || !member.isWay()) continue;
                    nodePool.addAll(ReplaceGeometryUtils.getUnimportantNodes(member.getWay()));
                }
            } else assert (false);
            nodeToReplace = ReplaceGeometryUtils.findNearestNode(subjectNode, nodePool);
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        AbstractMap nodeTags = (AbstractMap)subjectNode.getKeys();
        List<Command> tagResolutionCommands = ReplaceGeometryUtils.getTagConflictResolutionCommands((OsmPrimitive)subjectNode, referenceObject);
        if (tagResolutionCommands == null) {
            return false;
        }
        commands.addAll(tagResolutionCommands);
        if (nodeToReplace != null) {
            Way parentWay = (Way)nodeToReplace.getReferrers().get(0);
            List wayNodes = parentWay.getNodes();
            int idx = wayNodes.indexOf(nodeToReplace);
            wayNodes.set(idx, subjectNode);
            if (idx == 0 && parentWay.isClosed()) {
                wayNodes.set(wayNodes.size() - 1, subjectNode);
            }
            commands.add(new ChangeNodesCommand(parentWay, wayNodes));
            commands.add(new MoveCommand(subjectNode, nodeToReplace.getCoor()));
            commands.add(new DeleteCommand((OsmPrimitive)nodeToReplace));
            if (!nodeTags.isEmpty()) {
                for (String key : nodeTags.keySet()) {
                    commands.add(new ChangePropertyCommand((OsmPrimitive)subjectNode, key, null));
                }
            }
        } else {
            commands.add(new DeleteCommand((OsmPrimitive)subjectNode));
        }
        Main.main.getCurrentDataSet().setSelected(new PrimitiveId[]{referenceObject});
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry for node {0}", (Object[])new Object[]{subjectNode.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
        return true;
    }

    public static boolean replaceWayWithNew(List<Way> selection) {
        int idxNew;
        boolean overrideNewCheck = false;
        int n = idxNew = selection.get(0).isNew() ? 0 : 1;
        if (selection.get(1 - idxNew).isNew()) {
            boolean areNewNodes = false;
            for (Node n2 : selection.get(0).getNodes()) {
                if (!n2.isNew()) continue;
                areNewNodes = true;
            }
            idxNew = areNewNodes ? 0 : 1;
            overrideNewCheck = true;
            for (Node n2 : selection.get(1 - idxNew).getNodes()) {
                if (!n2.isNew()) continue;
                overrideNewCheck = false;
            }
        }
        Way referenceWay = selection.get(idxNew);
        Way subjectWay = selection.get(1 - idxNew);
        if (!(overrideNewCheck || !subjectWay.isNew() && referenceWay.isNew())) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"Please select one way that exists in the database and one new way with correct geometry.", (Object[])new Object[0]), TITLE, 2);
            return false;
        }
        return ReplaceGeometryUtils.replaceWay(subjectWay, referenceWay);
    }

    public static boolean replaceWay(Way subjectWay, Way referenceWay) {
        Area a = Main.main.getCurrentDataSet().getDataSourceArea();
        if (!ReplaceGeometryUtils.isInArea(subjectWay, a) || !ReplaceGeometryUtils.isInArea(referenceWay, a)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The ways must be entirely within the downloaded area.", (Object[])new Object[0]), TITLE, 2);
            return false;
        }
        if (ReplaceGeometryUtils.hasImportantNode(referenceWay, subjectWay)) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr((String)"The way to be replaced cannot have any nodes with properties or relation memberships unless they belong to both ways.", (Object[])new Object[0]), TITLE, 2);
            return false;
        }
        ArrayList<Object> commands = new ArrayList<Object>();
        List<Command> tagResolutionCommands = ReplaceGeometryUtils.getTagConflictResolutionCommands((OsmPrimitive)referenceWay, (OsmPrimitive)subjectWay);
        if (tagResolutionCommands == null) {
            return false;
        }
        commands.addAll(tagResolutionCommands);
        List<Node> nodePool = ReplaceGeometryUtils.getUnimportantNodes(subjectWay);
        LinkedList<Node> geometryPool = new LinkedList<Node>();
        for (Node node : referenceWay.getNodes()) {
            List referrers = node.getReferrers();
            if (!node.isNew() || node.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)referenceWay) || subjectWay.containsNode(node) || ReplaceGeometryUtils.hasInterestingKey((OsmPrimitive)node) || geometryPool.contains(node)) continue;
            geometryPool.add(node);
        }
        boolean useHungarian = Main.pref.getBoolean("utilsplugin2.replace-geometry.robustAssignment", false);
        HashMap<Object, Node> nodeAssoc = new HashMap<Object, Node>();
        if (geometryPool.size() > 0 && nodePool.size() > 0) {
            if (useHungarian) {
                int gLen = geometryPool.size();
                int nLen = nodePool.size();
                double[][] cost = new double[nLen][gLen];
                double maxDistance = Double.parseDouble(Main.pref.get("utilsplugin2.replace-geometry.max-distance", "1"));
                for (int i = 0; i < nLen; ++i) {
                    for (int j = 0; j < gLen; ++j) {
                        double d = nodePool.get(i).getCoor().distance((Point2D)((Node)geometryPool.get(j)).getCoor());
                        cost[i][j] = d > maxDistance ? Double.MAX_VALUE : d;
                    }
                }
                int[][] assignment = HungarianAlgorithm.hgAlgorithm(cost, "min");
                for (int i = 0; i < nLen; ++i) {
                    int nIdx = assignment[i][0];
                    int gIdx = assignment[i][1];
                    if (cost[nIdx][gIdx] == Double.MAX_VALUE) continue;
                    nodeAssoc.put(geometryPool.get(gIdx), nodePool.get(nIdx));
                }
                for (Node n : nodeAssoc.values()) {
                    nodePool.remove(n);
                }
            } else {
                for (Node n : geometryPool) {
                    Node nearest = ReplaceGeometryUtils.findNearestNode(n, nodePool);
                    if (nearest == null) continue;
                    nodeAssoc.put(n, nearest);
                    nodePool.remove(nearest);
                }
            }
        }
        for (Node n : geometryPool) {
            if (!nodeAssoc.containsKey(n)) continue;
            nodePool.add(n);
        }
        List geometryNodes = referenceWay.getNodes();
        for (int i = 0; i < geometryNodes.size(); ++i) {
            if (!nodeAssoc.containsKey(geometryNodes.get(i))) continue;
            geometryNodes.set(i, nodeAssoc.get(geometryNodes.get(i)));
        }
        commands.add(new ChangeNodesCommand(subjectWay, geometryNodes));
        for (Node node : nodeAssoc.keySet()) {
            commands.add(new MoveCommand((Node)nodeAssoc.get(node), node.getCoor()));
        }
        Main.main.getCurrentDataSet().clearSelection(new PrimitiveId[]{referenceWay});
        commands.add(new DeleteCommand((OsmPrimitive)referenceWay));
        if (!nodePool.isEmpty()) {
            commands.add(new DeleteCommand(nodePool));
        }
        Main.main.undoRedo.add((Command)new SequenceCommand(I18n.tr((String)"Replace geometry for way {0}", (Object[])new Object[]{subjectWay.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), commands));
        return true;
    }

    protected static List<Node> getUnimportantNodes(Way way) {
        LinkedList<Node> nodePool = new LinkedList<Node>();
        for (Node n : way.getNodes()) {
            List referrers = n.getReferrers();
            if (n.isDeleted() || referrers.size() != 1 || !((OsmPrimitive)referrers.get(0)).equals((Object)way) || ReplaceGeometryUtils.hasInterestingKey((OsmPrimitive)n) || nodePool.contains(n)) continue;
            nodePool.add(n);
        }
        return nodePool;
    }

    protected static boolean hasImportantNode(Way geometry, Way way) {
        for (Node n : way.getNodes()) {
            if (geometry.containsNode(n)) continue;
            for (OsmPrimitive o : n.getReferrers()) {
                if (!(o instanceof Relation)) continue;
                return true;
            }
            if (!ReplaceGeometryUtils.hasInterestingKey((OsmPrimitive)n)) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasInterestingKey(OsmPrimitive object) {
        for (String key : object.getKeys().keySet()) {
            if (OsmPrimitive.isUninterestingKey((String)key)) continue;
            return true;
        }
        return false;
    }

    protected static boolean isInArea(Node node, Area area) {
        return node.isNewOrUndeleted() || area == null || area.contains((Point2D)node.getCoor());
    }

    protected static boolean isInArea(Way way, Area area) {
        if (area == null) {
            return true;
        }
        for (Node n : way.getNodes()) {
            if (ReplaceGeometryUtils.isInArea(n, area)) continue;
            return false;
        }
        return true;
    }

    protected static List<Command> getTagConflictResolutionCommands(OsmPrimitive source, OsmPrimitive target) {
        List<OsmPrimitive> primitives = Arrays.asList(source, target);
        Set relationToNodeReferences = RelationToChildReference.getRelationToChildReferences(primitives);
        TagCollection tags = TagCollection.unionOfAllPrimitives(primitives);
        TagConflictResolutionUtil.combineTigerTags((TagCollection)tags);
        TagConflictResolutionUtil.normalizeTagCollectionBeforeEditing((TagCollection)tags, primitives);
        TagCollection tagsToEdit = new TagCollection(tags);
        TagConflictResolutionUtil.completeTagCollectionForEditing((TagCollection)tagsToEdit);
        CombinePrimitiveResolverDialog dialog = CombinePrimitiveResolverDialog.getInstance();
        dialog.getTagConflictResolverModel().populate(tagsToEdit, tags.getKeysWithMultipleValues());
        dialog.getRelationMemberConflictResolverModel().populate((Collection)relationToNodeReferences);
        dialog.setTargetPrimitive(target);
        dialog.prepareDefaultDecisions();
        if (!tags.isApplicableToPrimitive() || relationToNodeReferences.size() > 1) {
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                return null;
            }
        }
        return dialog.buildResolutionCommands();
    }

    protected static Node findNearestNode(Node node, Collection<Node> nodes) {
        if (nodes.contains(node)) {
            return node;
        }
        Node nearest = null;
        double distance = Double.parseDouble(Main.pref.get("utilsplugin2.replace-geometry.max-distance", "1"));
        LatLon coor = node.getCoor();
        for (Node n : nodes) {
            double d = n.getCoor().distance((Point2D)coor);
            if (!(d < distance)) continue;
            distance = d;
            nearest = n;
        }
        return nearest;
    }
}

