/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.util.Map;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.resources.i18n.Errors;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;

public abstract class AbstractParameterDescriptor
extends AbstractIdentifiedObject
implements GeneralParameterDescriptor {
    private static final long serialVersionUID = -2630644278783845276L;
    private final int minimumOccurs;

    protected AbstractParameterDescriptor(Map<String, ?> properties, int minimumOccurs, int maximumOccurs) {
        super(properties);
        this.minimumOccurs = minimumOccurs;
        if (minimumOccurs < 0 || maximumOccurs < minimumOccurs) {
            throw new IllegalArgumentException(Errors.format(14, minimumOccurs, maximumOccurs));
        }
    }

    @Override
    public abstract GeneralParameterValue createValue();

    @Override
    public int getMinimumOccurs() {
        return this.minimumOccurs;
    }

    @Override
    public abstract int getMaximumOccurs();

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (super.equals(object, compareMetadata)) {
            AbstractParameterDescriptor that = (AbstractParameterDescriptor)object;
            return this.minimumOccurs == that.minimumOccurs;
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 0x58ACDC64 ^ this.minimumOccurs;
    }
}

