/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.awt.geom.Point2D;
import java.io.Serializable;
import java.util.Arrays;
import org.geotools.geometry.AbstractDirectPosition;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.Cloneable;

public class GeneralDirectPosition
extends AbstractDirectPosition
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 9071833698385715524L;
    public final double[] ordinates;
    private CoordinateReferenceSystem crs;

    public GeneralDirectPosition(int numDim) throws NegativeArraySizeException {
        this.ordinates = new double[numDim];
    }

    public GeneralDirectPosition(double[] ordinates) {
        this.ordinates = (double[])ordinates.clone();
    }

    public GeneralDirectPosition(double x, double y) {
        this.ordinates = new double[]{x, y};
    }

    public GeneralDirectPosition(Point2D point) {
        this(point.getX(), point.getY());
    }

    public GeneralDirectPosition(DirectPosition point) {
        this.ordinates = point.getCoordinate();
        this.crs = point.getCoordinateReferenceSystem();
    }

    @Override
    public final CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) throws MismatchedDimensionException {
        GeneralDirectPosition.checkCoordinateReferenceSystemDimension(crs, this.getDimension());
        this.crs = crs;
    }

    @Override
    public final int getDimension() {
        return this.ordinates.length;
    }

    @Override
    public final double[] getCoordinate() {
        return (double[])this.ordinates.clone();
    }

    @Override
    public final double getOrdinate(int dimension) throws IndexOutOfBoundsException {
        return this.ordinates[dimension];
    }

    @Override
    public final void setOrdinate(int dimension, double value) throws IndexOutOfBoundsException {
        this.ordinates[dimension] = value;
    }

    @Override
    public int hashCode() {
        int code = Arrays.hashCode(this.ordinates);
        if (this.crs != null) {
            code += this.crs.hashCode();
        }
        assert (code == super.hashCode());
        return code;
    }

    @Override
    public GeneralDirectPosition clone() {
        return new GeneralDirectPosition(this.ordinates);
    }
}

