/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.shapefile.shp;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import org.geotools.data.shapefile.shp.ShapeHandler;
import org.geotools.data.shapefile.shp.ShapeType;
import org.geotools.data.shapefile.shp.ShapefileException;

public class MultiPointHandler
implements ShapeHandler {
    final ShapeType shapeType;
    GeometryFactory geometryFactory;

    public MultiPointHandler(ShapeType type, GeometryFactory gf) throws ShapefileException {
        if (type != ShapeType.MULTIPOINT && type != ShapeType.MULTIPOINTM && type != ShapeType.MULTIPOINTZ) {
            throw new ShapefileException("Multipointhandler constructor - expected type to be 8, 18, or 28");
        }
        this.shapeType = type;
        this.geometryFactory = gf;
    }

    private Object createNull() {
        Coordinate[] c = null;
        return this.geometryFactory.createMultiPoint(c);
    }

    @Override
    public Object read(ByteBuffer buffer, ShapeType type, boolean flatGeometry) {
        int t;
        if (type == ShapeType.NULL) {
            return this.createNull();
        }
        buffer.position(buffer.position() + 32);
        int numpoints = buffer.getInt();
        int dimensions = this.shapeType == ShapeType.MULTIPOINTZ && !flatGeometry ? 3 : 2;
        CoordinateSequence cs = this.geometryFactory.getCoordinateSequenceFactory().create(numpoints, dimensions);
        DoubleBuffer dbuffer = buffer.asDoubleBuffer();
        double[] ordinates = new double[numpoints * 2];
        dbuffer.get(ordinates);
        for (t = 0; t < numpoints; ++t) {
            cs.setOrdinate(t, 0, ordinates[t * 2]);
            cs.setOrdinate(t, 1, ordinates[t * 2 + 1]);
        }
        if (dimensions > 2) {
            dbuffer.position(dbuffer.position() + 2);
            dbuffer.get(ordinates, 0, numpoints);
            for (t = 0; t < numpoints; ++t) {
                cs.setOrdinate(t, 2, ordinates[t]);
            }
        }
        return this.geometryFactory.createMultiPoint(cs);
    }
}

