/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.AttributeReader;
import org.geotools.data.FIDReader;
import org.geotools.data.FeatureReader;
import org.geotools.feature.IllegalAttributeException;
import org.geotools.feature.SchemaException;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FIDFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private final AttributeReader attributeReader;
    private final SimpleFeatureType schema;
    private final FIDReader fidReader;
    private SimpleFeatureBuilder builder;
    private Boolean hasNextFlag;

    public FIDFeatureReader(AttributeReader attributeReader, FIDReader fidReader, SimpleFeatureType schema) throws SchemaException {
        this.attributeReader = attributeReader;
        this.fidReader = fidReader;
        if (schema == null) {
            schema = this.createSchema();
        }
        this.schema = schema;
        this.builder = new SimpleFeatureBuilder(schema);
    }

    @Override
    public SimpleFeature next() throws IOException, IllegalAttributeException, NoSuchElementException {
        if (this.hasNext()) {
            this.hasNextFlag = null;
            this.attributeReader.next();
            return this.readFeature(this.attributeReader);
        }
        throw new NoSuchElementException("There are no more Features to be read");
    }

    protected SimpleFeatureType createSchema() throws SchemaException {
        SimpleFeatureTypeBuilder b = new SimpleFeatureTypeBuilder();
        b.setName("xxx");
        int ii = this.attributeReader.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            b.add(this.attributeReader.getAttributeType(i));
        }
        return b.buildFeatureType();
    }

    protected SimpleFeature readFeature(AttributeReader atts) throws IllegalAttributeException, IOException {
        String fid = this.fidReader.next();
        int ii = atts.getAttributeCount();
        for (int i = 0; i < ii; ++i) {
            this.builder.add(atts.read(i));
        }
        return this.builder.buildFeature(fid);
    }

    @Override
    public void close() throws IOException {
        this.fidReader.close();
        this.attributeReader.close();
    }

    @Override
    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.hasNextFlag == null) {
            this.hasNextFlag = this.attributeReader.hasNext();
        }
        return this.hasNextFlag;
    }
}

