/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.intervalrtree;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.io.WKTWriter;
import java.util.Comparator;

public abstract class IntervalRTreeNode {
    protected double min = Double.POSITIVE_INFINITY;
    protected double max = Double.NEGATIVE_INFINITY;

    public abstract void query(double var1, double var3, ItemVisitor var5);

    protected boolean intersects(double d, double d2) {
        return !(this.min > d2) && !(this.max < d);
    }

    public String toString() {
        return WKTWriter.toLineString(new Coordinate(this.min, 0.0), new Coordinate(this.max, 0.0));
    }

    public static class NodeComparator
    implements Comparator {
        public int compare(Object object, Object object2) {
            IntervalRTreeNode intervalRTreeNode = (IntervalRTreeNode)object;
            IntervalRTreeNode intervalRTreeNode2 = (IntervalRTreeNode)object2;
            double d = (intervalRTreeNode.min + intervalRTreeNode.max) / 2.0;
            double d2 = (intervalRTreeNode2.min + intervalRTreeNode2.max) / 2.0;
            if (d < d2) {
                return -1;
            }
            if (d > d2) {
                return 1;
            }
            return 0;
        }
    }
}

