/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequenceFactory;
import com.vividsolutions.jts.util.Assert;
import java.io.Serializable;
import java.util.Collection;

public class GeometryFactory
implements Serializable {
    private static final long serialVersionUID = -6820524753094095635L;
    private PrecisionModel precisionModel;
    private CoordinateSequenceFactory coordinateSequenceFactory;

    public GeometryFactory(PrecisionModel precisionModel, int n, CoordinateSequenceFactory coordinateSequenceFactory) {
        this.precisionModel = precisionModel;
        this.coordinateSequenceFactory = coordinateSequenceFactory;
    }

    public GeometryFactory(CoordinateSequenceFactory coordinateSequenceFactory) {
        this(new PrecisionModel(), 0, coordinateSequenceFactory);
    }

    public GeometryFactory(PrecisionModel precisionModel, int n) {
        this(precisionModel, n, GeometryFactory.getDefaultCoordinateSequenceFactory());
    }

    public GeometryFactory() {
        this(new PrecisionModel(), 0);
    }

    private static CoordinateSequenceFactory getDefaultCoordinateSequenceFactory() {
        return CoordinateArraySequenceFactory.instance();
    }

    public static Point[] toPointArray(Collection<? extends Geometry> collection) {
        Point[] pointArray = new Point[collection.size()];
        return collection.toArray(pointArray);
    }

    public static Geometry[] toGeometryArray(Collection<? extends Geometry> collection) {
        if (collection == null) {
            return null;
        }
        Geometry[] geometryArray = new Geometry[collection.size()];
        return collection.toArray(geometryArray);
    }

    public static LineString[] toLineStringArray(Collection<? extends Geometry> collection) {
        LineString[] lineStringArray = new LineString[collection.size()];
        return collection.toArray(lineStringArray);
    }

    public static Polygon[] toPolygonArray(Collection<? extends Geometry> collection) {
        Polygon[] polygonArray = new Polygon[collection.size()];
        return collection.toArray(polygonArray);
    }

    public PrecisionModel getPrecisionModel() {
        return this.precisionModel;
    }

    public Point createPoint(Coordinate coordinate) {
        return this.createPoint(coordinate != null ? this.getCoordinateSequenceFactory().create(new Coordinate[]{coordinate}) : null);
    }

    public Point createPoint(CoordinateSequence coordinateSequence) {
        return new Point(coordinateSequence, this);
    }

    public MultiLineString createMultiLineString(LineString[] lineStringArray) {
        return new MultiLineString(lineStringArray, this);
    }

    public GeometryCollection createGeometryCollection(Geometry[] geometryArray) {
        return new GeometryCollection(geometryArray, this);
    }

    public MultiPolygon createMultiPolygon(Polygon[] polygonArray) {
        return new MultiPolygon(polygonArray, this);
    }

    public LinearRing createLinearRing(Coordinate[] coordinateArray) {
        return this.createLinearRing(coordinateArray != null ? this.getCoordinateSequenceFactory().create(coordinateArray) : null);
    }

    public LinearRing createLinearRing(CoordinateSequence coordinateSequence) {
        return new LinearRing(coordinateSequence, this);
    }

    public MultiPoint createMultiPoint(Point[] pointArray) {
        return new MultiPoint(pointArray, this);
    }

    public MultiPoint createMultiPoint(Coordinate[] coordinateArray) {
        return this.createMultiPoint(coordinateArray != null ? this.getCoordinateSequenceFactory().create(coordinateArray) : null);
    }

    public MultiPoint createMultiPoint(CoordinateSequence coordinateSequence) {
        if (coordinateSequence == null) {
            return this.createMultiPoint(new Point[0]);
        }
        Point[] pointArray = new Point[coordinateSequence.size()];
        for (int i = 0; i < coordinateSequence.size(); ++i) {
            pointArray[i] = this.createPoint(coordinateSequence.getCoordinate(i));
        }
        return this.createMultiPoint(pointArray);
    }

    public Polygon createPolygon(LinearRing linearRing, LinearRing[] linearRingArray) {
        return new Polygon(linearRing, linearRingArray, this);
    }

    public Geometry buildGeometry(Collection<? extends Geometry> collection) {
        boolean bl;
        Class<?> clazz = null;
        boolean bl2 = false;
        boolean bl3 = false;
        for (Geometry geometry : collection) {
            Class<?> clazz2 = geometry.getClass();
            if (clazz == null) {
                clazz = clazz2;
            }
            if (clazz2 != clazz) {
                bl2 = true;
            }
            if (!(geometry instanceof GeometryCollection)) continue;
            bl3 = true;
        }
        if (clazz == null) {
            return this.createGeometryCollection(null);
        }
        if (bl2 || bl3) {
            return this.createGeometryCollection(GeometryFactory.toGeometryArray(collection));
        }
        Geometry geometry = collection.iterator().next();
        boolean bl4 = bl = collection.size() > 1;
        if (bl) {
            if (geometry instanceof Polygon) {
                return this.createMultiPolygon(GeometryFactory.toPolygonArray(collection));
            }
            if (geometry instanceof LineString) {
                return this.createMultiLineString(GeometryFactory.toLineStringArray(collection));
            }
            if (geometry instanceof Point) {
                return this.createMultiPoint(GeometryFactory.toPointArray(collection));
            }
            Assert.shouldNeverReachHere("Unhandled class: " + geometry.getClass().getName());
        }
        return geometry;
    }

    public LineString createLineString(Coordinate[] coordinateArray) {
        return this.createLineString(coordinateArray != null ? this.getCoordinateSequenceFactory().create(coordinateArray) : null);
    }

    public LineString createLineString(CoordinateSequence coordinateSequence) {
        return new LineString(coordinateSequence, this);
    }

    public CoordinateSequenceFactory getCoordinateSequenceFactory() {
        return this.coordinateSequenceFactory;
    }
}

