/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata.core.io.archive;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.bind.JAXBException;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.AbstractReader;
import org.openstreetmap.josm.plugins.opendata.OdPlugin;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.datasets.AbstractDataSetHandler;
import org.openstreetmap.josm.plugins.opendata.core.io.NeptuneReader;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.CandidateChooser;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmzReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpReader;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.TabReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsReader;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsReader;

public class ZipReader
extends AbstractReader
implements OdConstants {
    private final ZipInputStream zis;
    private final AbstractDataSetHandler handler;

    public ZipReader(ZipInputStream zis, AbstractDataSetHandler handler) {
        this.zis = zis;
        this.handler = handler;
    }

    public static DataSet parseDataSet(InputStream in, AbstractDataSetHandler handler, ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError, JAXBException {
        return new ZipReader(new ZipInputStream(in), handler).parseDoc(instance);
    }

    private static final File createTempDir() throws IOException {
        File temp = File.createTempFile("josm_opendata_temp_", Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }

    private static final void deleteDir(File dir) {
        for (File file : dir.listFiles()) {
            file.delete();
        }
        dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataSet parseDoc(ProgressMonitor instance) throws IOException, XMLStreamException, FactoryConfigurationError, JAXBException {
        File temp = ZipReader.createTempDir();
        ArrayList<File> candidates = new ArrayList<File>();
        try {
            byte[] buffer;
            File file;
            ZipEntry entry;
            block4: while ((entry = this.zis.getNextEntry()) != null) {
                file = new File(temp + File.separator + entry.getName());
                if (file.exists() && !file.delete()) {
                    throw new IOException("Could not delete temp file: " + file.getAbsolutePath());
                }
                if (!file.createNewFile()) {
                    throw new IOException("Could not create temp file: " + file.getAbsolutePath());
                }
                FileOutputStream fos = new FileOutputStream(file);
                buffer = new byte[8192];
                int count = 0;
                while ((count = this.zis.read(buffer, 0, buffer.length)) > 0) {
                    fos.write(buffer, 0, count);
                }
                fos.close();
                for (String ext : new String[]{"csv", "kml", "kmz", "xls", "ods", "shp", "mif", "tab", "xml"}) {
                    if (!entry.getName().toLowerCase().endsWith("." + ext)) continue;
                    candidates.add(file);
                    System.out.println(entry.getName());
                    continue block4;
                }
            }
            file = null;
            if (candidates.size() > 1) {
                CandidateChooser dialog = (CandidateChooser)new CandidateChooser(instance.getWindowParent(), candidates).showDialog();
                if (dialog.getValue() != 1) {
                    buffer = null;
                    return buffer;
                }
                file = dialog.getSelectedFile();
            } else if (candidates.size() == 1) {
                file = (File)candidates.get(0);
            }
            if (file != null) {
                DataSet from = null;
                FileInputStream in = new FileInputStream(file);
                if (file.getName().toLowerCase().endsWith("csv")) {
                    from = CsvReader.parseDataSet(in, this.handler, instance);
                } else if (file.getName().toLowerCase().endsWith("kml")) {
                    from = KmlReader.parseDataSet(in, instance);
                } else if (file.getName().toLowerCase().endsWith("kmz")) {
                    from = KmzReader.parseDataSet(in, instance);
                } else if (file.getName().toLowerCase().endsWith("xls")) {
                    from = XlsReader.parseDataSet(in, this.handler, instance);
                } else if (file.getName().toLowerCase().endsWith("ods")) {
                    from = OdsReader.parseDataSet(in, this.handler, instance);
                } else if (file.getName().toLowerCase().endsWith("shp")) {
                    from = ShpReader.parseDataSet(in, file, this.handler, instance);
                } else if (file.getName().toLowerCase().endsWith("mif")) {
                    from = MifReader.parseDataSet(in, file, this.handler, instance);
                } else if (file.getName().toLowerCase().endsWith("tab")) {
                    from = TabReader.parseDataSet(in, file, this.handler, instance);
                } else if (file.getName().toLowerCase().endsWith("xml")) {
                    if (OdPlugin.getInstance().xmlImporter.acceptFile(file)) {
                        from = NeptuneReader.parseDataSet(in, this.handler, instance);
                    } else {
                        System.err.println("Unsupported XML file: " + file.getName());
                    }
                } else {
                    System.err.println("Unsupported file extension: " + file.getName());
                }
                if (from != null) {
                    this.ds.mergeFrom(from);
                }
            }
        }
        finally {
            ZipReader.deleteDir(temp);
        }
        return this.ds;
    }
}

