/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.opendata;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.gui.MapFrame;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.preferences.PreferenceSetting;
import org.openstreetmap.josm.plugins.Plugin;
import org.openstreetmap.josm.plugins.PluginInformation;
import org.openstreetmap.josm.plugins.opendata.core.OdConstants;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdDialog;
import org.openstreetmap.josm.plugins.opendata.core.gui.OdPreferenceSetting;
import org.openstreetmap.josm.plugins.opendata.core.io.AbstractImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.XmlImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.archive.ZipImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.KmlKmzImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.MifTabImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.geographic.ShpImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.CsvImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.OdsImporter;
import org.openstreetmap.josm.plugins.opendata.core.io.tabular.XlsImporter;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleHandler;
import org.openstreetmap.josm.plugins.opendata.core.modules.ModuleInformation;

public final class OdPlugin
extends Plugin
implements OdConstants {
    private static OdPlugin instance;
    public final XmlImporter xmlImporter;

    public OdPlugin(PluginInformation info) {
        super(info);
        if (instance != null) {
            throw new IllegalAccessError("Cannot instantiate plugin twice !");
        }
        instance = this;
        AbstractImporter[] abstractImporterArray = new AbstractImporter[8];
        abstractImporterArray[0] = new CsvImporter();
        abstractImporterArray[1] = new OdsImporter();
        abstractImporterArray[2] = new XlsImporter();
        abstractImporterArray[3] = new KmlKmzImporter();
        abstractImporterArray[4] = new ShpImporter();
        abstractImporterArray[5] = new MifTabImporter();
        abstractImporterArray[6] = new ZipImporter();
        this.xmlImporter = new XmlImporter();
        abstractImporterArray[7] = this.xmlImporter;
        for (AbstractImporter importer : Arrays.asList(abstractImporterArray)) {
            ExtensionFileFilter.importers.add(0, importer);
        }
        this.loadModules();
    }

    public static final OdPlugin getInstance() {
        return instance;
    }

    public void mapFrameInitialized(MapFrame oldFrame, MapFrame newFrame) {
        if (newFrame != null) {
            newFrame.addToggleDialog((ToggleDialog)new OdDialog());
        }
    }

    public PreferenceSetting getPreferenceSetting() {
        return new OdPreferenceSetting();
    }

    private final void loadModules() {
        List<ModuleInformation> modulesToLoad = ModuleHandler.buildListOfModulesToLoad(Main.parent);
        if (!modulesToLoad.isEmpty() && ModuleHandler.checkAndConfirmModuleUpdate(Main.parent)) {
            modulesToLoad = ModuleHandler.updateModules(Main.parent, modulesToLoad, null);
        }
        ModuleHandler.installDownloadedModules(true);
        ModuleHandler.loadModules(Main.parent, modulesToLoad, null);
    }

    private final File getSubDirectory(String name) {
        File dir = new File(this.getPluginDir() + File.separator + name);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public final File getModulesDirectory() {
        return this.getSubDirectory("modules");
    }

    public final File getResourcesDirectory() {
        return this.getSubDirectory("resources");
    }
}

