/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.StandardRecord;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndianOutput;

public final class RowRecord
extends StandardRecord {
    public static final short sid = 520;
    public static final int ENCODED_SIZE = 20;
    private static final int OPTION_BITS_ALWAYS_SET = 256;
    private int field_1_row_number;
    private int field_2_first_col;
    private int field_3_last_col;
    private short field_4_height;
    private short field_5_optimize;
    private short field_6_reserved;
    private int field_7_option_flags;
    private static final BitField outlineLevel = BitFieldFactory.getInstance(7);
    private static final BitField colapsed = BitFieldFactory.getInstance(16);
    private static final BitField zeroHeight = BitFieldFactory.getInstance(32);
    private static final BitField badFontHeight = BitFieldFactory.getInstance(64);
    private static final BitField formatted = BitFieldFactory.getInstance(128);
    private short field_8_xf_index;

    public RowRecord(int n) {
        this.field_1_row_number = n;
        this.field_4_height = (short)255;
        this.field_5_optimize = 0;
        this.field_6_reserved = 0;
        this.field_7_option_flags = 256;
        this.field_8_xf_index = (short)15;
        this.setEmpty();
    }

    public RowRecord(RecordInputStream recordInputStream) {
        this.field_1_row_number = recordInputStream.readUShort();
        this.field_2_first_col = recordInputStream.readShort();
        this.field_3_last_col = recordInputStream.readShort();
        this.field_4_height = recordInputStream.readShort();
        this.field_5_optimize = recordInputStream.readShort();
        this.field_6_reserved = recordInputStream.readShort();
        this.field_7_option_flags = recordInputStream.readShort();
        this.field_8_xf_index = recordInputStream.readShort();
    }

    public void setEmpty() {
        this.field_2_first_col = 0;
        this.field_3_last_col = 0;
    }

    public boolean isEmpty() {
        return (this.field_2_first_col | this.field_3_last_col) == 0;
    }

    public void setRowNumber(int n) {
        this.field_1_row_number = n;
    }

    public void setFirstCol(int n) {
        this.field_2_first_col = n;
    }

    public void setLastCol(int n) {
        this.field_3_last_col = n;
    }

    public int getRowNumber() {
        return this.field_1_row_number;
    }

    public int getFirstCol() {
        return this.field_2_first_col;
    }

    public int getLastCol() {
        return this.field_3_last_col;
    }

    public short getHeight() {
        return this.field_4_height;
    }

    public short getOptimize() {
        return this.field_5_optimize;
    }

    public short getOptionFlags() {
        return (short)this.field_7_option_flags;
    }

    public short getOutlineLevel() {
        return (short)outlineLevel.getValue(this.field_7_option_flags);
    }

    public boolean getColapsed() {
        return colapsed.isSet(this.field_7_option_flags);
    }

    public boolean getZeroHeight() {
        return zeroHeight.isSet(this.field_7_option_flags);
    }

    public boolean getBadFontHeight() {
        return badFontHeight.isSet(this.field_7_option_flags);
    }

    public boolean getFormatted() {
        return formatted.isSet(this.field_7_option_flags);
    }

    public short getXFIndex() {
        return this.field_8_xf_index;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ROW]\n");
        stringBuffer.append("    .rownumber      = ").append(Integer.toHexString(this.getRowNumber())).append("\n");
        stringBuffer.append("    .firstcol       = ").append(HexDump.shortToHex(this.getFirstCol())).append("\n");
        stringBuffer.append("    .lastcol        = ").append(HexDump.shortToHex(this.getLastCol())).append("\n");
        stringBuffer.append("    .height         = ").append(HexDump.shortToHex(this.getHeight())).append("\n");
        stringBuffer.append("    .optimize       = ").append(HexDump.shortToHex(this.getOptimize())).append("\n");
        stringBuffer.append("    .reserved       = ").append(HexDump.shortToHex(this.field_6_reserved)).append("\n");
        stringBuffer.append("    .optionflags    = ").append(HexDump.shortToHex(this.getOptionFlags())).append("\n");
        stringBuffer.append("        .outlinelvl = ").append(Integer.toHexString(this.getOutlineLevel())).append("\n");
        stringBuffer.append("        .colapsed   = ").append(this.getColapsed()).append("\n");
        stringBuffer.append("        .zeroheight = ").append(this.getZeroHeight()).append("\n");
        stringBuffer.append("        .badfontheig= ").append(this.getBadFontHeight()).append("\n");
        stringBuffer.append("        .formatted  = ").append(this.getFormatted()).append("\n");
        stringBuffer.append("    .xfindex        = ").append(Integer.toHexString(this.getXFIndex())).append("\n");
        stringBuffer.append("[/ROW]\n");
        return stringBuffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput littleEndianOutput) {
        littleEndianOutput.writeShort(this.getRowNumber());
        littleEndianOutput.writeShort(this.getFirstCol() == -1 ? 0 : this.getFirstCol());
        littleEndianOutput.writeShort(this.getLastCol() == -1 ? 0 : this.getLastCol());
        littleEndianOutput.writeShort(this.getHeight());
        littleEndianOutput.writeShort(this.getOptimize());
        littleEndianOutput.writeShort(this.field_6_reserved);
        littleEndianOutput.writeShort(this.getOptionFlags());
        littleEndianOutput.writeShort(this.getXFIndex());
    }

    @Override
    protected int getDataSize() {
        return 16;
    }

    @Override
    public short getSid() {
        return 520;
    }

    @Override
    public Object clone() {
        RowRecord rowRecord = new RowRecord(this.field_1_row_number);
        rowRecord.field_2_first_col = this.field_2_first_col;
        rowRecord.field_3_last_col = this.field_3_last_col;
        rowRecord.field_4_height = this.field_4_height;
        rowRecord.field_5_optimize = this.field_5_optimize;
        rowRecord.field_6_reserved = this.field_6_reserved;
        rowRecord.field_7_option_flags = this.field_7_option_flags;
        rowRecord.field_8_xf_index = this.field_8_xf_index;
        return rowRecord;
    }
}

