/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.cs;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.measure.converter.ConversionException;
import javax.measure.converter.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.geotools.measure.Measure;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.referencing.cs.DefaultCoordinateSystemAxis;
import org.geotools.referencing.cs.DirectionAlongMeridian;
import org.geotools.referencing.cs.PredefinedCS;
import org.geotools.referencing.operation.matrix.GeneralMatrix;
import org.geotools.resources.Classes;
import org.geotools.resources.i18n.Errors;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.util.Utilities;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.operation.Matrix;
import org.opengis.util.InternationalString;

public class AbstractCS
extends AbstractIdentifiedObject
implements CoordinateSystem {
    private static final long serialVersionUID = 6757665252533744744L;
    private static final DefaultCoordinateSystemAxis[] DIRECTION_CHECKS = new DefaultCoordinateSystemAxis[]{DefaultCoordinateSystemAxis.NORTHING, DefaultCoordinateSystemAxis.EASTING, DefaultCoordinateSystemAxis.SOUTHING, DefaultCoordinateSystemAxis.WESTING};
    private final CoordinateSystemAxis[] axis;
    private transient Unit<?> distanceUnit;

    public AbstractCS(String name, CoordinateSystemAxis[] axis) {
        this(Collections.singletonMap("name", name), axis);
    }

    public AbstractCS(Map<String, ?> properties, CoordinateSystemAxis[] axis) {
        super(properties);
        AbstractCS.ensureNonNull("axis", axis);
        this.axis = (CoordinateSystemAxis[])axis.clone();
        for (int i = 0; i < axis.length; ++i) {
            AbstractCS.ensureNonNull("axis", axis, i);
            AxisDirection direction = axis[i].getDirection();
            AbstractCS.ensureNonNull("direction", direction);
            if (!this.isCompatibleDirection(direction)) {
                throw new IllegalArgumentException(Errors.format(60, direction.name(), this.getClass()));
            }
            Unit<?> unit = axis[i].getUnit();
            AbstractCS.ensureNonNull("unit", unit);
            if (!this.isCompatibleUnit(direction, unit)) {
                throw new IllegalArgumentException(Errors.format(76, unit));
            }
            AxisDirection check = direction.absolute();
            if (!check.equals(AxisDirection.OTHER)) {
                int j = i;
                while (--j >= 0) {
                    if (!check.equals(axis[j].getDirection().absolute())) continue;
                    String nameI = axis[i].getDirection().name();
                    String nameJ = axis[j].getDirection().name();
                    throw new IllegalArgumentException(Errors.format(36, nameI, nameJ));
                }
            }
            String name = axis[i].getName().getCode();
            for (int j = 0; j < DIRECTION_CHECKS.length; ++j) {
                DirectionAlongMeridian m;
                AxisDirection expected;
                DefaultCoordinateSystemAxis candidate = DIRECTION_CHECKS[j];
                if (!candidate.nameMatches(name) || direction.equals(expected = candidate.getDirection()) || (m = DirectionAlongMeridian.parse(direction)) != null) continue;
                throw new IllegalArgumentException(Errors.format(77, name, direction.name()));
            }
        }
    }

    static Map<String, Object> name(int key) {
        HashMap<String, Object> properties = new HashMap<String, Object>(4);
        InternationalString name = Vocabulary.formatInternational(key);
        properties.put("name", ((Object)name).toString());
        properties.put("alias", name);
        return properties;
    }

    protected boolean isCompatibleDirection(AxisDirection direction) {
        return true;
    }

    protected boolean isCompatibleUnit(AxisDirection direction, Unit<?> unit) {
        return true;
    }

    @Override
    public int getDimension() {
        return this.axis.length;
    }

    @Override
    public CoordinateSystemAxis getAxis(int dimension) throws IndexOutOfBoundsException {
        return this.axis[dimension];
    }

    private static AxisDirection[] getAxisDirections(CoordinateSystem cs) {
        AxisDirection[] axis = new AxisDirection[cs.getDimension()];
        for (int i = 0; i < axis.length; ++i) {
            axis[i] = cs.getAxis(i).getDirection();
        }
        return axis;
    }

    public static Matrix swapAndScaleAxis(CoordinateSystem sourceCS, CoordinateSystem targetCS) throws IllegalArgumentException, ConversionException {
        if (!Classes.sameInterfaces(sourceCS.getClass(), targetCS.getClass(), CoordinateSystem.class)) {
            throw new IllegalArgumentException(Errors.format(73));
        }
        Object[] sourceAxis = AbstractCS.getAxisDirections(sourceCS);
        Object[] targetAxis = AbstractCS.getAxisDirections(targetCS);
        GeneralMatrix matrix = new GeneralMatrix((AxisDirection[])sourceAxis, (AxisDirection[])targetAxis);
        assert (Arrays.equals(sourceAxis, targetAxis) == matrix.isIdentity()) : matrix;
        int sourceDim = matrix.getNumCol() - 1;
        int targetDim = matrix.getNumRow() - 1;
        assert (sourceDim == sourceCS.getDimension()) : sourceCS;
        assert (targetDim == targetCS.getDimension()) : targetCS;
        for (int j = 0; j < targetDim; ++j) {
            Unit<?> targetUnit = targetCS.getAxis(j).getUnit();
            for (int i = 0; i < sourceDim; ++i) {
                Unit<?> sourceUnit;
                double element = matrix.getElement(j, i);
                if (element == 0.0 || Utilities.equals(sourceUnit = sourceCS.getAxis(i).getUnit(), targetUnit)) continue;
                UnitConverter converter = sourceUnit.getConverterTo(targetUnit);
                if (!converter.isLinear()) {
                    throw new ConversionException(Errors.format(114, sourceUnit, targetUnit));
                }
                double offset = converter.convert(0.0);
                double scale = converter.convert(1.0) - offset;
                matrix.setElement(j, i, element * scale);
                matrix.setElement(j, sourceDim, matrix.getElement(j, sourceDim) + element * offset);
            }
        }
        return matrix;
    }

    public static CoordinateSystem standard(CoordinateSystem cs) throws IllegalArgumentException {
        return PredefinedCS.standard(cs);
    }

    final Unit<?> getDistanceUnit() throws ConversionException {
        Unit<?> unit = this.distanceUnit;
        if (unit == null) {
            for (int i = 0; i < this.axis.length; ++i) {
                Unit<Angle> candidate = this.axis[i].getUnit();
                if (candidate == null || candidate.isCompatible(SI.RADIAN)) continue;
                if (unit != null) {
                    UnitConverter converter = candidate.getConverterTo(unit);
                    if (!converter.isLinear()) {
                        throw new ConversionException("Unit conversion is non-linear");
                    }
                    double scale = converter.convert(1.0) - converter.convert(0.0);
                    if (Math.abs(scale) <= 1.0) continue;
                }
                unit = candidate;
            }
            this.distanceUnit = unit;
        }
        return unit;
    }

    final void ensureDimensionMatch(String name, double[] coordinates) throws MismatchedDimensionException {
        if (coordinates.length != this.axis.length) {
            throw new MismatchedDimensionException(Errors.format(94, name, coordinates.length, this.axis.length));
        }
    }

    public Measure distance(double[] coord1, double[] coord2) throws UnsupportedOperationException, MismatchedDimensionException {
        throw new UnsupportedOperationException();
    }

    private static DefaultCoordinateSystemAxis[] getDefaultAxis(CoordinateSystem cs) {
        DefaultCoordinateSystemAxis[] axis = new DefaultCoordinateSystemAxis[cs.getDimension()];
        for (int i = 0; i < axis.length; ++i) {
            CoordinateSystemAxis a = cs.getAxis(i);
            DefaultCoordinateSystemAxis c = DefaultCoordinateSystemAxis.getPredefined(a);
            if (c == null) {
                c = a instanceof DefaultCoordinateSystemAxis ? (DefaultCoordinateSystemAxis)a : new DefaultCoordinateSystemAxis(a);
            }
            axis[i] = c;
        }
        return axis;
    }

    final boolean axisColinearWith(CoordinateSystem userCS) {
        if (userCS.getDimension() != this.getDimension()) {
            return false;
        }
        DefaultCoordinateSystemAxis[] axis0 = AbstractCS.getDefaultAxis(this);
        DefaultCoordinateSystemAxis[] axis1 = AbstractCS.getDefaultAxis(userCS);
        for (int i = 0; i < axis0.length; ++i) {
            block5: {
                DefaultCoordinateSystemAxis direct = axis0[i];
                DefaultCoordinateSystemAxis opposite = direct.getOpposite();
                for (int j = 0; j < axis1.length; ++j) {
                    DefaultCoordinateSystemAxis candidate = axis1[j];
                    if (candidate == null || !candidate.equals(direct, false, false) && (opposite == null || !candidate.equals(opposite, false, false))) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            axis1[j] = null;
        }
        assert (this.directionColinearWith(userCS));
        return true;
    }

    final boolean directionColinearWith(CoordinateSystem userCS) {
        int i;
        if (userCS.getDimension() != this.axis.length) {
            return false;
        }
        AxisDirection[] checks = new AxisDirection[this.axis.length];
        for (i = 0; i < checks.length; ++i) {
            checks[i] = userCS.getAxis(i).getDirection().absolute();
        }
        for (i = 0; i < this.axis.length; ++i) {
            block5: {
                AxisDirection direction = this.axis[i].getDirection().absolute();
                for (int j = 0; j < checks.length; ++j) {
                    AxisDirection candidate = checks[j];
                    if (candidate == null || !candidate.equals(direction)) {
                        continue;
                    }
                    break block5;
                }
                return false;
            }
            checks[j] = null;
        }
        return true;
    }

    @Override
    public boolean equals(AbstractIdentifiedObject object, boolean compareMetadata) {
        if (object == this) {
            return true;
        }
        if (super.equals(object, compareMetadata)) {
            AbstractCS that = (AbstractCS)object;
            return AbstractCS.equals(this.axis, that.axis, compareMetadata);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int code = 1480995944;
        for (int i = 0; i < this.axis.length; ++i) {
            code = code * 37 + this.axis[i].hashCode();
        }
        return code;
    }
}

