/*
 * Decompiled with CFR 0.152.
 */
package javax.measure.unit;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.measure.converter.RationalConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Duration;
import javax.measure.quantity.Length;
import javax.measure.quantity.Quantity;
import javax.measure.unit.AlternateUnit;
import javax.measure.unit.BaseUnit;
import javax.measure.unit.SystemOfUnits;
import javax.measure.unit.Unit;

public final class SI
extends SystemOfUnits {
    private static HashSet<Unit<?>> UNITS = new HashSet();
    public static final BaseUnit<Length> METRE = SI.si(new BaseUnit("m"));
    public static final Unit<Length> METER = METRE;
    public static final BaseUnit<Duration> SECOND = SI.si(new BaseUnit("s"));
    public static final AlternateUnit<Angle> RADIAN = SI.si(new AlternateUnit("rad", Unit.ONE));
    static final RationalConverter Em3 = new RationalConverter(1L, 1000L);

    private SI() {
    }

    public static <Q extends Quantity> Unit<Q> MILLI(Unit<Q> unit) {
        return unit.transform(Em3);
    }

    @Override
    public Set<Unit<?>> getUnits() {
        return Collections.unmodifiableSet(UNITS);
    }

    private static <U extends Unit<?>> U si(U u) {
        UNITS.add(u);
        return u;
    }
}

