/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.index.strtree;

import com.vividsolutions.jts.index.ItemVisitor;
import com.vividsolutions.jts.index.strtree.AbstractNode;
import com.vividsolutions.jts.index.strtree.Boundable;
import com.vividsolutions.jts.index.strtree.ItemBoundable;
import com.vividsolutions.jts.util.Assert;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractSTRtree {
    protected AbstractNode root;
    private boolean built = false;
    private ArrayList itemBoundables = new ArrayList();
    private int nodeCapacity;

    public AbstractSTRtree(int n) {
        Assert.isTrue(n > 1, "Node capacity must be greater than 1");
        this.nodeCapacity = n;
    }

    public void build() {
        Assert.isTrue(!this.built);
        this.root = this.itemBoundables.isEmpty() ? this.createNode(0) : this.createHigherLevels(this.itemBoundables, -1);
        this.built = true;
    }

    protected abstract AbstractNode createNode(int var1);

    protected List createParentBoundables(List list, int n) {
        Assert.isTrue(!list.isEmpty());
        ArrayList<AbstractNode> arrayList = new ArrayList<AbstractNode>();
        arrayList.add(this.createNode(n));
        ArrayList arrayList2 = new ArrayList(list);
        Collections.sort(arrayList2, this.getComparator());
        for (Boundable boundable : arrayList2) {
            if (this.lastNode(arrayList).getChildBoundables().size() == this.getNodeCapacity()) {
                arrayList.add(this.createNode(n));
            }
            this.lastNode(arrayList).addChildBoundable(boundable);
        }
        return arrayList;
    }

    protected AbstractNode lastNode(List list) {
        return (AbstractNode)list.get(list.size() - 1);
    }

    protected int compareDoubles(double d, double d2) {
        return d > d2 ? 1 : (d < d2 ? -1 : 0);
    }

    private AbstractNode createHigherLevels(List list, int n) {
        Assert.isTrue(!list.isEmpty());
        List list2 = this.createParentBoundables(list, n + 1);
        if (list2.size() == 1) {
            return (AbstractNode)list2.get(0);
        }
        return this.createHigherLevels(list2, n + 1);
    }

    public int getNodeCapacity() {
        return this.nodeCapacity;
    }

    protected int size() {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            return 0;
        }
        return this.size(this.root);
    }

    protected int size(AbstractNode abstractNode) {
        int n = 0;
        for (Boundable boundable : abstractNode.getChildBoundables()) {
            if (boundable instanceof AbstractNode) {
                n += this.size((AbstractNode)boundable);
                continue;
            }
            if (!(boundable instanceof ItemBoundable)) continue;
            ++n;
        }
        return n;
    }

    protected int depth() {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            return 0;
        }
        return this.depth(this.root);
    }

    protected int depth(AbstractNode abstractNode) {
        int n = 0;
        for (Boundable boundable : abstractNode.getChildBoundables()) {
            int n2;
            if (!(boundable instanceof AbstractNode) || (n2 = this.depth((AbstractNode)boundable)) <= n) continue;
            n = n2;
        }
        return n + 1;
    }

    protected void insert(Object object, Object object2) {
        Assert.isTrue(!this.built, "Cannot insert items into an STR packed R-tree after it has been built.");
        this.itemBoundables.add(new ItemBoundable(object, object2));
    }

    protected List query(Object object) {
        if (!this.built) {
            this.build();
        }
        ArrayList arrayList = new ArrayList();
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue(this.root.getBounds() == null);
            return arrayList;
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), object)) {
            this.query(object, this.root, arrayList);
        }
        return arrayList;
    }

    protected void query(Object object, ItemVisitor itemVisitor) {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue(this.root.getBounds() == null);
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), object)) {
            this.query(object, this.root, itemVisitor);
        }
    }

    protected abstract IntersectsOp getIntersectsOp();

    private void query(Object object, AbstractNode abstractNode, List list) {
        for (Boundable boundable : abstractNode.getChildBoundables()) {
            if (!this.getIntersectsOp().intersects(boundable.getBounds(), object)) continue;
            if (boundable instanceof AbstractNode) {
                this.query(object, (AbstractNode)boundable, list);
                continue;
            }
            if (boundable instanceof ItemBoundable) {
                list.add(((ItemBoundable)boundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    private void query(Object object, AbstractNode abstractNode, ItemVisitor itemVisitor) {
        for (Boundable boundable : abstractNode.getChildBoundables()) {
            if (!this.getIntersectsOp().intersects(boundable.getBounds(), object)) continue;
            if (boundable instanceof AbstractNode) {
                this.query(object, (AbstractNode)boundable, itemVisitor);
                continue;
            }
            if (boundable instanceof ItemBoundable) {
                itemVisitor.visitItem(((ItemBoundable)boundable).getItem());
                continue;
            }
            Assert.shouldNeverReachHere();
        }
    }

    protected boolean remove(Object object, Object object2) {
        if (!this.built) {
            this.build();
        }
        if (this.itemBoundables.isEmpty()) {
            Assert.isTrue(this.root.getBounds() == null);
        }
        if (this.getIntersectsOp().intersects(this.root.getBounds(), object)) {
            return this.remove(object, this.root, object2);
        }
        return false;
    }

    private boolean removeItem(AbstractNode abstractNode, Object object) {
        Boundable boundable = null;
        for (Boundable boundable2 : abstractNode.getChildBoundables()) {
            if (!(boundable2 instanceof ItemBoundable) || ((ItemBoundable)boundable2).getItem() != object) continue;
            boundable = boundable2;
        }
        if (boundable != null) {
            abstractNode.getChildBoundables().remove(boundable);
            return true;
        }
        return false;
    }

    private boolean remove(Object object, AbstractNode abstractNode, Object object2) {
        boolean bl = this.removeItem(abstractNode, object2);
        if (bl) {
            return true;
        }
        AbstractNode abstractNode2 = null;
        for (Boundable boundable : abstractNode.getChildBoundables()) {
            if (!this.getIntersectsOp().intersects(boundable.getBounds(), object) || !(boundable instanceof AbstractNode) || !(bl = this.remove(object, (AbstractNode)boundable, object2))) continue;
            abstractNode2 = (AbstractNode)boundable;
            break;
        }
        if (abstractNode2 != null && abstractNode2.getChildBoundables().isEmpty()) {
            abstractNode.getChildBoundables().remove(abstractNode2);
        }
        return bl;
    }

    protected abstract Comparator getComparator();

    protected static interface IntersectsOp {
        public boolean intersects(Object var1, Object var2);
    }
}

