/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom.prep;

import com.vividsolutions.jts.algorithm.PointLocator;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.prep.PreparedLineString;
import com.vividsolutions.jts.geom.util.ComponentCoordinateExtracter;
import com.vividsolutions.jts.noding.SegmentStringUtil;
import java.util.List;

class PreparedLineStringIntersects {
    protected PreparedLineString prepLine;

    public static boolean intersects(PreparedLineString preparedLineString, Geometry geometry) {
        PreparedLineStringIntersects preparedLineStringIntersects = new PreparedLineStringIntersects(preparedLineString);
        return preparedLineStringIntersects.intersects(geometry);
    }

    public PreparedLineStringIntersects(PreparedLineString preparedLineString) {
        this.prepLine = preparedLineString;
    }

    public boolean intersects(Geometry geometry) {
        List list = SegmentStringUtil.extractSegmentStrings(geometry);
        boolean bl = this.prepLine.getIntersectionFinder().intersects(list);
        if (bl) {
            return true;
        }
        if (geometry.getDimension() == 1) {
            return false;
        }
        if (geometry.getDimension() == 2 && this.prepLine.isAnyTargetComponentInTest(geometry)) {
            return true;
        }
        if (geometry.getDimension() == 0) {
            return this.isAnyTestPointInTarget(geometry);
        }
        return false;
    }

    protected boolean isAnyTestPointInTarget(Geometry geometry) {
        PointLocator pointLocator = new PointLocator();
        List list = ComponentCoordinateExtracter.getCoordinates(geometry);
        for (Coordinate coordinate : list) {
            if (!pointLocator.intersects(coordinate, this.prepLine.getGeometry())) continue;
            return true;
        }
        return false;
    }
}

