/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.geom;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.operation.BoundaryOp;

public class MultiLineString
extends GeometryCollection
implements Lineal {
    private static final long serialVersionUID = 8166665132445433741L;

    public MultiLineString(LineString[] lineStringArray, GeometryFactory geometryFactory) {
        super(lineStringArray, geometryFactory);
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public int getBoundaryDimension() {
        if (this.isClosed()) {
            return -1;
        }
        return 0;
    }

    @Override
    public String getGeometryType() {
        return "MultiLineString";
    }

    public boolean isClosed() {
        if (this.isEmpty()) {
            return false;
        }
        for (int i = 0; i < this.geometries.length; ++i) {
            if (((LineString)this.geometries[i]).isClosed()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Geometry getBoundary() {
        return new BoundaryOp(this).getBoundary();
    }

    @Override
    public Geometry reverse() {
        int n = this.geometries.length;
        LineString[] lineStringArray = new LineString[n];
        for (int i = 0; i < this.geometries.length; ++i) {
            lineStringArray[n - 1 - i] = (LineString)this.geometries[i].reverse();
        }
        return this.getFactory().createMultiLineString(lineStringArray);
    }

    @Override
    public boolean equalsExact(Geometry geometry, double d) {
        if (!this.isEquivalentClass(geometry)) {
            return false;
        }
        return super.equalsExact(geometry, d);
    }
}

