/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.conflation;

import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.OsmPrimitive;

public final class ConflationUtils {
    private static final double MAX_COST = Double.MAX_VALUE;

    public static EastNorth getCenter(OsmPrimitive prim) {
        LatLon center = prim.getBBox().getTopLeft().getCenter(prim.getBBox().getBottomRight());
        return Main.map.mapView.getProjection().latlon2eastNorth(center);
    }

    public static double calcCost(OsmPrimitive referenceObject, OsmPrimitive subjectObject) {
        if (referenceObject == subjectObject) {
            return Double.MAX_VALUE;
        }
        try {
            return ConflationUtils.getCenter(referenceObject).distance(ConflationUtils.getCenter(subjectObject));
        }
        catch (Exception e) {
            return Double.MAX_VALUE;
        }
    }
}

